/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class GetProcessHangUpNodeIdsCmd
implements Command<Set<String>>,
Serializable {
    private static final long serialVersionUID = 6643555299386985632L;
    private Log logger = LogFactory.getLog(this.getClass());
    private Long procInstId;

    public GetProcessHangUpNodeIdsCmd(Long procInstId) {
        this.procInstId = procInstId;
    }

    @Override
    public Set<String> execute(CommandContext commandContext) {
        String handles = WfUtils.listToStringWithQuotes(Arrays.asList(RuntimeUtil.getDeadLetterJobStr()), ",");
        String sql = "SELECT D.FELEMENTID,E.FSUSPENSIONSTATE,E.FPROCESSTYPE FROM T_WF_EXECUTION E INNER JOIN T_WF_DEADLETTERJOB D ON E.FPROCINSTID = D.FPROCESSINSTANCEID WHERE E.FPROCINSTID = ? AND E.FISSCOPE = '1' AND D.FHANDLERTYPE IN (" + handles + ") ";
        String algoKey = "wf.engine.viewflowchart.querySuspend";
        HashSet<String> ret = new HashSet<String>();
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{this.procInstId});){
            for (Row r : ds) {
                String suspensionState = r.getString("FSUSPENSIONSTATE");
                String processType = r.getString("FPROCESSTYPE");
                boolean col = ModelType.BizFlow.name().equalsIgnoreCase(processType) || ModelType.AuditFlow.name().equalsIgnoreCase(processType) && ManagementConstants.SUSPENDED.getStateCode().equalsIgnoreCase(suspensionState);
                if (!col) continue;
                ret.add(r.getString("FELEMENTID"));
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u67e5\u8be2\u6d41\u7a0b\u6302\u8d77\u8282\u70b9\u51fa\u9519\uff01 \u6d41\u7a0b\u5b9e\u4f8bID: %s  \u539f\u56e0: %s", this.procInstId, WfUtils.getExceptionStacktrace(e)));
        }
        return ret;
    }
}

