/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetSSCOrAutoOrNotifyTaskCountCmd
implements Command<Integer> {
    private List<Long> executionIds;

    public GetSSCOrAutoOrNotifyTaskCountCmd(List<Long> executionIds) {
        this.executionIds = executionIds;
    }

    @Override
    public Integer execute(CommandContext commandContext) {
        if (this.executionIds == null || this.executionIds.isEmpty()) {
            return 0;
        }
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.executionIds.size(); ++i) {
            sb.append(this.executionIds.get(i)).append(",");
        }
        if (sb.length() > 1) {
            String sql = "SELECT COUNT(0) count from t_wf_execution WHERE (FACTID like '%SSCApprove%' OR FACTID like '%NotifyTask%' OR FACTID like '%AutoTask%') AND FPROCINSTID in ";
            String inProInstIds = sb.substring(0, sb.length() - 1) + ")";
            try (DataSet ds = DB.queryDataSet((String)"Wf.query", (DBRoute)DBRoute.workflow, (String)(sql + inProInstIds));){
                Iterator iter = ds.iterator();
                int count = 0;
                if (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    count = Integer.parseInt(String.valueOf(r.get("count")));
                }
                Integer n = count;
                return n;
            }
        }
        return 0;
    }
}

