/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetSubProcIdsClassifiedByDeployStateCmd
implements Command<Map<String, List<Long>>>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ALL = "all";
    public static final String DEPLOYED = "deployed";
    public static final String UNDEPLOYED = "undeployed";
    protected Long modelId;

    public GetSubProcIdsClassifiedByDeployStateCmd(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Map<String, List<Long>> execute(CommandContext commandContext) {
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>();
        ArrayList<Long> allIds = new ArrayList<Long>();
        ArrayList<Long> deployedIds = new ArrayList<Long>();
        ArrayList<Long> undeployedIds = new ArrayList<Long>();
        String json = commandContext.getResourceEntityManager().findByModelIdAndType(this.modelId, "graph_json").getData();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(json);
        List<EventSubProcess> eventSubProcs = bpmnModel.getMainProcess().findFlowElementsOfType(EventSubProcess.class);
        if (!eventSubProcs.isEmpty()) {
            String id = null;
            for (EventSubProcess subProc : eventSubProcs) {
                id = subProc.getSubProcessId();
                if (this.isBeDeployed(commandContext, id)) {
                    deployedIds.add(Long.valueOf(id));
                } else {
                    undeployedIds.add(Long.valueOf(id));
                }
                allIds.add(Long.valueOf(id));
            }
        }
        idMap.put(ALL, allIds);
        idMap.put(DEPLOYED, deployedIds);
        idMap.put(UNDEPLOYED, undeployedIds);
        return idMap;
    }

    private boolean isBeDeployed(CommandContext commandContext, String modelId) {
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)modelId)};
        List entities = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", null);
        return entities != null && !entities.isEmpty();
    }
}

