/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class GetSuspendedExecutionsCmd
implements Command<List<ExecutionEntity>> {
    private List<Long> executionIds;

    public GetSuspendedExecutionsCmd(List<Long> executionIds) {
        this.executionIds = executionIds;
    }

    @Override
    public List<ExecutionEntity> execute(CommandContext commandContext) {
        if (this.executionIds == null || this.executionIds.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter f = new QFilter("id", "in", this.executionIds).and(new QFilter("suspensionState", "=", (Object)ManagementConstants.SUSPENDED.getStateCode()));
        return commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{f});
    }
}

