/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class GetTaskHandleLogBetweentTimeCmd
implements Command<List<TaskHandleLogEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Date endDate;
    private Date startDate;
    private String orderBy;
    private int limitSize;

    public GetTaskHandleLogBetweentTimeCmd(Date startTime, Date endTime, String orderby, int limitSize) {
        this.startDate = startTime;
        this.endDate = endTime;
        this.orderBy = orderby;
        this.limitSize = limitSize;
    }

    @Override
    public List<TaskHandleLogEntity> execute(CommandContext commandContext) {
        if (this.endDate == null || this.startDate == null) {
            return new ArrayList<TaskHandleLogEntity>();
        }
        EntityQueryBuilder eqb = commandContext.getTaskHandleLogEntityManager().createQueryBuilder();
        eqb.addFilter("createdate", "<", this.endDate);
        eqb.addFilter("createdate", ">=", this.startDate);
        eqb.addFilter("taskid", "!=", 0L);
        if (WfUtils.isNotEmpty(this.orderBy)) {
            eqb.orderBy(this.orderBy);
        }
        if (this.limitSize != 0) {
            eqb.setLimit(this.limitSize);
        }
        return commandContext.getTaskHandleLogEntityManager().findByQueryBuilder(eqb);
    }
}

