/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;

public class GetTaskIdentityLinkEntityBetweenTimeCmd
implements Command<List<IdentityLinkEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Date endDate;
    private Date startDate;
    private String orderBy;
    private int limitSize;

    public GetTaskIdentityLinkEntityBetweenTimeCmd(Date startTime, Date endTime, String orderby, int limitSize) {
        this.startDate = startTime;
        this.endDate = endTime;
        this.orderBy = orderby;
        this.limitSize = limitSize;
    }

    @Override
    public List<IdentityLinkEntity> execute(CommandContext commandContext) {
        if (this.endDate == null || this.startDate == null) {
            return new ArrayList<IdentityLinkEntity>();
        }
        this.endDate = this.getDateBeforeStep(this.endDate);
        EntityQueryBuilder eqb = commandContext.getIdentityLinkEntityManager().createQueryBuilder();
        eqb.addFilter("createdate", "<", this.endDate);
        eqb.addFilter("createdate", ">=", this.startDate);
        eqb.addFilter("taskid", "!=", 0L);
        eqb.addFilter("businesskey", "=", Character.valueOf(' '));
        if (WfUtils.isNotEmpty(this.orderBy)) {
            eqb.orderBy(this.orderBy);
        }
        if (this.limitSize != 0) {
            eqb.setLimit(this.limitSize);
        }
        return commandContext.getIdentityLinkEntityManager().findByQueryBuilder(eqb);
    }

    Date getDateBeforeStep(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, 1);
        return cal.getTime();
    }
}

