/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;

public class GetUserIdsByCalculateCmd
implements Command<List<Long>> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String businessKey;
    private VariableScope variableScope;
    private List<ParticipantModelEntityImpl> participants;

    public GetUserIdsByCalculateCmd(String businessKey, VariableScope variableScope, List<ParticipantModelEntityImpl> participants) {
        this.businessKey = businessKey;
        this.variableScope = variableScope;
        this.participants = participants;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        PreComputatorExecutionEntityImpl preComputatorExecutionEntityImpl;
        DynamicObject model;
        if (this.variableScope instanceof BusinessModelVariableScope) {
            DynamicObject model2 = ((BusinessModelVariableScope)this.variableScope).getModel();
            if (null != model2) {
                commandContext.setParsedBusinessObject(model2);
            }
        } else if (this.variableScope instanceof PreComputatorExecutionEntityImpl && null != (model = (preComputatorExecutionEntityImpl = (PreComputatorExecutionEntityImpl)this.variableScope).getTransientBill())) {
            commandContext.setParsedBusinessObject(model);
        }
        ParticipantCalculator calculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
        List<Long> userIds = new ArrayList<Long>();
        try {
            userIds = calculator.getUserIds(this.businessKey, this.variableScope, this.participants);
            userIds = WfUtils.filterEnableUsers(userIds);
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return userIds;
    }
}

