/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.HandleFailedJobResult;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.util.ToDoJobUtil;

public class HandleFailedJobsCmd
implements Command<HandleFailedJobResult> {
    private List<Long> jobIds;
    private Log log = LogFactory.getLog(this.getClass());

    public HandleFailedJobsCmd(List<Long> jobIds) {
        this.jobIds = jobIds;
    }

    @Override
    public HandleFailedJobResult execute(CommandContext commandContext) {
        HandleFailedJobResult ret = new HandleFailedJobResult();
        FailedJobEntityManager manager = commandContext.getFailedJobEntityManager();
        int successed = 0;
        int failed = 0;
        ArrayList<String> failMsgList = new ArrayList<String>(this.jobIds.size());
        ArrayList<String> successMsgList = new ArrayList<String>(this.jobIds.size());
        FailedJobEntity failedJob = null;
        String reason = null;
        for (Long jobId : this.jobIds) {
            failedJob = (FailedJobEntity)manager.findById(jobId);
            if (failedJob == null) continue;
            reason = this.handleFailedJob(commandContext, failedJob);
            if (reason == null) {
                ++successed;
                successMsgList.add(jobId + "");
                continue;
            }
            ++failed;
            ret.setReason(reason);
            failMsgList.add(jobId + ":" + reason);
        }
        ret.setSuccessed(successed);
        ret.setFailed(failed);
        ret.setFailMsgList(failMsgList);
        ret.setSuccessMsgList(successMsgList);
        return ret;
    }

    private String handleFailedJob(CommandContext commandContext, FailedJobEntity failedJob) {
        Long jobId = failedJob.getId();
        try {
            ToDoJobUtil.reExecuteFailedJob(commandContext, failedJob);
            commandContext.getFailedJobEntityManager().delete(jobId);
        }
        catch (Exception e) {
            this.log.info(String.format(WFMultiLangConstants.getDealTodoFail(), WfUtils.getExceptionStacktrace(e)));
            return e.getMessage();
        }
        return null;
    }
}

