/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessDefinitionCmd;
import kd.bos.workflow.engine.impl.cmd.management.ImportSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.model.DeployModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.scheme.enumeration.ImportType;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;

public class ImportProcessFileContentCmd
implements Command<Map<String, Object>> {
    private String content;
    private String processType;
    private Boolean forceNew;
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_MODELID = "modelId";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";

    public ImportProcessFileContentCmd(String content, String processType) {
        this.content = content;
        this.processType = processType;
    }

    public ImportProcessFileContentCmd(String content, String processType, boolean forceNew) {
        this(content, processType);
        if (ModelType.NoCodeFlow.name().equals(processType)) {
            this.forceNew = forceNew;
        }
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.content)) {
            return this.failed(new HashMap<String, Object>(), this.getFileContentIsEmptyTip());
        }
        int length = this.content.length();
        this.log.debug(String.format("ImportProcessFileContent: %s", this.content.substring(0, Math.min(255, length))));
        if (this.content.indexOf("<DeployModel>") > -1) {
            return this.importProcessModel(commandContext);
        }
        if (this.content.indexOf("<ExportScheme>") > -1) {
            return this.importProcessScheme(commandContext);
        }
        this.log.debug("invalid content.");
        return new HashMap<String, Object>();
    }

    private Map<String, Object> importProcessModel(CommandContext commandContext) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KEY_SUCCESS, true);
        DeployModel deployModel = null;
        try {
            deployModel = this.getDeployModelFromContent();
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        if (deployModel == null) {
            return this.failed(ret, this.getFileContentParsingFailedTip());
        }
        List<DynamicObject> models = deployModel.getModels();
        DynamicObject model = models.get(0);
        String processNumber = model.getString("key");
        String processName = model.getString("name");
        String type = model.getString("type");
        if (!type.equals(this.processType)) {
            return this.failed(ret, String.format(this.getInconsistentProcessTypesTip(), this.processType));
        }
        boolean isCover = false;
        if (!Boolean.TRUE.equals(this.forceNew)) {
            QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber)};
            long count = commandContext.getModelEntityManager().countByFilter("id", filters, false);
            isCover = count > 0L;
        }
        try {
            Long modelId = new DeployModelCmd(deployModel, isCover).execute(commandContext);
            ret.put(KEY_MODELID, modelId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
            return this.failed(ret, String.format(this.getImportFailedTip(), processNumber, processName, e.getMessage()));
        }
        return ret;
    }

    private DeployModel getDeployModelFromContent() {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployModel.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployModel deployModel = (DeployModel)serializer.deserializeFromString(this.content, null);
        if (Boolean.TRUE.equals(this.forceNew)) {
            List<DynamicObject> models = deployModel.getModels();
            DynamicObject model = models.get(0);
            String processNumber = model.getString("key");
            String newProcNumber = this.getNoCodeProcNumber();
            String newContent = this.content.replaceAll(processNumber, newProcNumber);
            deployModel = (DeployModel)serializer.deserializeFromString(newContent, null);
        }
        return deployModel;
    }

    private ExportScheme getExportSchemeFromContent() {
        DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        ExportScheme exportScheme = (ExportScheme)serializer.deserializeFromString(this.content, null);
        if (Boolean.TRUE.equals(this.forceNew)) {
            List<DynamicObject> processDefinitions = exportScheme.getProcessDefinitions();
            DynamicObject processDefinition = processDefinitions.get(0);
            String processNumber = processDefinition.getString("key");
            String newProcNumber = this.getNoCodeProcNumber();
            String newContent = this.content.replaceAll(processNumber, newProcNumber);
            exportScheme = (ExportScheme)serializer.deserializeFromString(newContent, null);
        }
        return exportScheme;
    }

    private Map<String, Object> importProcessScheme(CommandContext commandContext) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KEY_SUCCESS, true);
        ExportScheme exportScheme = null;
        try {
            exportScheme = this.getExportSchemeFromContent();
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        if (exportScheme == null) {
            return this.failed(ret, this.getFileContentParsingFailedTip());
        }
        List<DynamicObject> processDefinitions = exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = processDefinitions.get(0);
        String processNumber = processDefinition.getString("key");
        String processName = processDefinition.getString("name");
        String type = processDefinition.getString("type");
        if (!type.equals(this.processType)) {
            return this.failed(ret, String.format(this.getInconsistentProcessTypesTip(), this.processType));
        }
        boolean isNoCodeFlow = ModelType.NoCodeFlow.name().equals(type);
        ImportSchemeParameter parameter = new ImportSchemeParameter();
        parameter.setName(processName);
        parameter.setNumber(processNumber);
        parameter.setFilename(processNumber);
        parameter.setValidate(!isNoCodeFlow);
        boolean isCover = false;
        if (!Boolean.TRUE.equals(this.forceNew)) {
            QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber)};
            long count = commandContext.getProcessDefinitionEntityManager().countByFilter("id", filters, false);
            isCover = count > 0L;
        }
        ImportType importType = isCover ? ImportType.COVER : ImportType.CREATE;
        parameter.setImportType(importType);
        try {
            Long modelId = null;
            Object map = new ImportSchemeCmd(exportScheme, parameter).execute(commandContext);
            if (isNoCodeFlow && ImportType.CREATE == importType) {
                Long newModelId = (Long)map.get("newModelId");
                Long newProcDefId = (Long)map.get("newProcDefId");
                new ActivateProcessDefinitionCmd(newProcDefId, null, null).execute(commandContext);
                if (ModelType.NoCodeFlow.name().equals(this.processType)) {
                    this.replaceModelIdInJson(commandContext, newModelId);
                }
                modelId = newModelId;
            } else {
                modelId = (Long)map.get(KEY_MODELID);
            }
            ret.put(KEY_MODELID, modelId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
            return this.failed(ret, String.format(this.getImportFailedTip(), processNumber, processName, e.getMessage()));
        }
        return ret;
    }

    private void replaceModelIdInJson(CommandContext commandContext, Long newModelId) {
        ILocaleString multiData;
        ModelEntity newModel = (ModelEntity)commandContext.getModelEntityManager().findById(newModelId, "bpmnxmlid");
        if (newModel == null) {
            this.log.error("model is null.");
            return;
        }
        ResourceEntity modelResource = (ResourceEntity)commandContext.getResourceEntityManager().findById(newModel.getResourceId());
        if (modelResource == null) {
            this.log.error(String.format("resource is null. %s", newModelId));
            return;
        }
        String data = modelResource.getData();
        if (WfUtils.isEmpty(data)) {
            this.log.error(String.format("resourceData is null. %s", newModelId));
            return;
        }
        JSONObject json = JSON.parseObject((String)data);
        String resourceId = json.getString("resourceId");
        String newId = String.valueOf(newModelId);
        if (resourceId != null && !resourceId.equals(newId)) {
            modelResource.setData(data.replaceAll(resourceId, newId));
        }
        if ((multiData = modelResource.getContent()) != null) {
            LocaleString newMultiData = new LocaleString();
            for (Map.Entry entry : multiData.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                newMultiData.setItem((String)entry.getKey(), (Object)value.replaceAll(resourceId, newId));
            }
            modelResource.setContent((ILocaleString)newMultiData);
        }
    }

    private Map<String, Object> failed(Map<String, Object> ret, String message) {
        ret.put(KEY_SUCCESS, false);
        ret.put(KEY_MESSAGE, message);
        return ret;
    }

    private String getNoCodeProcNumber() {
        Long id = ORM.create().genLongId("wf_model");
        return String.format("Proc_%s_%s", new SimpleDateFormat("yyyyMMdd").format(new Date()), id);
    }

    private String getFileContentIsEmptyTip() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ImportProcessFileContentCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private String getFileContentParsingFailedTip() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u89e3\u6790\u5931\u8d25\u3002", (String)"ImportProcessFileContentCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private String getInconsistentProcessTypesTip() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u5bfc\u5165\u7684\u6d41\u7a0b\u7c7b\u578b\u4e0d\u662f %s\u3002", (String)"ImportProcessFileContentCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private String getImportFailedTip() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b %1$s\uff08%2$s\uff09\u5931\u8d25\uff0c\u539f\u56e0\uff1a%3$s", (String)"ImportProcessFileContentCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

