/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class IsRunningCmd
implements Command<Boolean> {
    private String businessykey;
    private Long taskId;
    private Long executionId;

    public IsRunningCmd(String businessykey, Long taskId, Long executionId) {
        this.businessykey = businessykey;
        this.executionId = executionId;
        this.taskId = taskId;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        HistoricTaskInstanceEntity task;
        if (WfUtils.isNotEmpty(this.businessykey)) {
            return RuntimeUtil.isRunning(commandContext, this.businessykey);
        }
        if (WfUtils.isNotEmpty(this.executionId)) {
            ExecutionEntity e = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
            if (e != null && WfUtils.isNotEmpty(e.getBusinessKey())) {
                return RuntimeUtil.isRunning(commandContext, e.getBusinessKey());
            }
        } else if (WfUtils.isNotEmpty(this.taskId) && (task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId)) != null && WfUtils.isNotEmpty(task.getBusinessKey())) {
            return RuntimeUtil.isRunning(commandContext, task.getBusinessKey());
        }
        return false;
    }
}

