/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.EntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import org.apache.commons.lang.StringUtils;

public class ModifyWorkflowBillNoCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(ModifyWorkflowBillNoCmd.class);
    private static final String ORDER_BY = "createdate desc";
    private static final String FNAME = "FNAME";
    private static final String FSUBJECT = "FSUBJECT";
    private TaskEntity task;

    public ModifyWorkflowBillNoCmd(TaskEntity task) {
        this.task = task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String businessKey = this.task.getBusinessKey();
        String oldBillNo = this.task.getBillNo();
        String entityNumber = this.task.getEntityNumber();
        Long processInstanceId = this.task.getProcessInstanceId();
        String newBillNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessKey);
        logger.debug(String.format("\u66f4\u65b0\u6d41\u7a0b\u4e2d\u7684\u5355\u636e\u7f16\u7801\uff1a\u5f53\u524d\u6d41\u7a0b\u7684businessKey:\u3010%1$s\u3011,\u5b9e\u4f53\u7f16\u7801\u3010%2$s\u3011,\u6d41\u7a0b\u5b9e\u4f8b\u3010%3$s\u3011\uff0c\u65e7\u7684\u5355\u636e\u7f16\u7801\u3010%4$s\u3011\uff0c\u65b0\u7684\u5355\u636e\u7f16\u7801\u3010%5$s\u3011", businessKey, entityNumber, processInstanceId, oldBillNo, newBillNo));
        if (StringUtils.isNotBlank((String)oldBillNo) && StringUtils.isNotBlank((String)newBillNo) && !StringUtils.equals((String)oldBillNo, (String)newBillNo) && WfUtils.isNotEmpty(newBillNo)) {
            this.updateBillNoInExecutions(commandContext, processInstanceId, newBillNo, oldBillNo);
            this.updateBillNoInTasks(commandContext, processInstanceId, newBillNo, oldBillNo);
            this.updateBillNoInHiTasks(commandContext, processInstanceId, newBillNo, oldBillNo);
            this.updateBillNoInHiProcInstance(commandContext, processInstanceId, newBillNo, oldBillNo);
            this.updateBillNoInHiActInstance(commandContext, processInstanceId, newBillNo);
            this.updateBillNoInDeadLetterJob(commandContext, processInstanceId, newBillNo, oldBillNo);
        }
        return null;
    }

    private void updateBillNoInDeadLetterJob(CommandContext commandContext, Long processInstanceId, String newBillNo, String oldBillNo) {
        DeadLetterJobEntityManager deadLetterJobEntityManager = commandContext.getDeadLetterJobEntityManager();
        List<DeadLetterJobEntity> deadLetters = deadLetterJobEntityManager.findJobsByProcessInstanceId(processInstanceId);
        if (CollectionUtil.isNotEmpty(deadLetters)) {
            ArrayList<Object[]> subjectParams = new ArrayList<Object[]>();
            ArrayList<Object[]> keyversionParams = new ArrayList<Object[]>();
            ArrayList<Object[]> params = new ArrayList<Object[]>(deadLetters.size());
            for (DeadLetterJobEntity deadLetter : deadLetters) {
                Long id = deadLetter.getId();
                ILocaleString keyversion = deadLetter.getKeyversion();
                ILocaleString subject = deadLetter.getSubject();
                this.builderLocaleValues(newBillNo, oldBillNo, subject, id, subjectParams);
                this.builderLocaleValues(newBillNo, oldBillNo, keyversion, id, keyversionParams);
                params.add(new Object[]{subject.toString(), keyversion.toString(), id});
            }
            this.batchUpdateLocaleData(deadLetterJobEntityManager, subjectParams, FSUBJECT, "T_WF_DEADLETTERJOB_L");
            this.batchUpdateLocaleData(deadLetterJobEntityManager, keyversionParams, FNAME, "T_WF_DEADLETTERJOB_L");
            if (CollectionUtil.isNotEmpty(params)) {
                String sql = "UPDATE T_WF_DEADLETTERJOB SET FSUBJECT = ? , FNAME = ? WHERE FID= ?";
                deadLetterJobEntityManager.addBatchSQLInfo(new BatchSQLInfo(sql, params, 100));
            }
        }
    }

    private void updateBillNoInHiActInstance(CommandContext commandContext, Long processInstanceId, String newBillNo) {
        HistoricActivityInstanceEntityManager hiActInstanceManger = commandContext.getHistoricActivityInstanceEntityManager();
        ArrayList<Object[]> billNoParams = new ArrayList<Object[]>(1);
        billNoParams.add(new Object[]{newBillNo, processInstanceId});
        if (CollectionUtil.isNotEmpty(billNoParams)) {
            String sql = "UPDATE T_WF_HIACTINST SET FBILLNO = ? WHERE FPROCINSTID= ?";
            hiActInstanceManger.addBatchSQLInfo(new BatchSQLInfo(sql, billNoParams, 100));
        }
    }

    private void updateBillNoInHiProcInstance(CommandContext commandContext, Long processInstanceId, String newBillNo, String oldBillNo) {
        QFilter q1 = new QFilter("id", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q1};
        HistoricProcessInstanceEntityManager hiProInstanceManger = commandContext.getHistoricProcessInstanceEntityManager();
        List hiProInstances = hiProInstanceManger.findByQueryFilters(qFilters, "id,name,subject,billno", ORDER_BY);
        if (CollectionUtil.isNotEmpty(hiProInstances)) {
            ArrayList<Object[]> subjectParams = new ArrayList<Object[]>();
            ArrayList<Object[]> nameParams = new ArrayList<Object[]>();
            ArrayList<Object[]> params = new ArrayList<Object[]>(hiProInstances.size());
            for (HistoricProcessInstanceEntity hiProInstance : hiProInstances) {
                Long id = hiProInstance.getId();
                ILocaleString name = hiProInstance.getName();
                ILocaleString subject = hiProInstance.getSubject();
                this.builderLocaleValues(newBillNo, oldBillNo, subject, id, subjectParams);
                this.builderLocaleValues(newBillNo, oldBillNo, name, id, nameParams);
                params.add(new Object[]{subject.toString(), name.toString(), newBillNo, id});
            }
            this.batchUpdateLocaleData(hiProInstanceManger, subjectParams, FSUBJECT, "T_WF_HIPROCINST_L");
            this.batchUpdateLocaleData(hiProInstanceManger, nameParams, FNAME, "T_WF_HIPROCINST_L");
            if (CollectionUtil.isNotEmpty(params)) {
                String sql = "UPDATE T_WF_HIPROCINST SET FSUBJECT = ? , FNAME = ? , FBILLNO = ? WHERE FID= ?";
                hiProInstanceManger.addBatchSQLInfo(new BatchSQLInfo(sql, params, 100));
            }
        }
    }

    private void updateBillNoInHiTasks(CommandContext commandContext, Long processInstanceId, String newBillNo, String oldBillNo) {
        QFilter q1 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q1};
        HistoricTaskInstanceEntityManager hiTaskInsManager = commandContext.getHistoricTaskInstanceEntityManager();
        List hiTaskInstances = hiTaskInsManager.findByQueryFilters(qFilters, "id,subject,billno", ORDER_BY);
        if (CollectionUtil.isNotEmpty(hiTaskInstances)) {
            ArrayList<Object[]> subjectParams = new ArrayList<Object[]>();
            ArrayList<Object[]> params = new ArrayList<Object[]>(hiTaskInstances.size());
            for (HistoricTaskInstanceEntity hiTaskInstance : hiTaskInstances) {
                Long id = hiTaskInstance.getId();
                ILocaleString subject = hiTaskInstance.getSubject();
                this.builderLocaleValues(newBillNo, oldBillNo, subject, id, subjectParams);
                params.add(new Object[]{subject.toString(), newBillNo, id});
            }
            this.batchUpdateLocaleData(hiTaskInsManager, subjectParams, FSUBJECT, "T_WF_HITASKINST_L");
            if (CollectionUtil.isNotEmpty(params)) {
                String sql = "UPDATE T_WF_HITASKINST SET FSUBJECT = ? , FBILLNO = ? WHERE FID= ?";
                hiTaskInsManager.addBatchSQLInfo(new BatchSQLInfo(sql, params, 100));
            }
        }
    }

    private void updateBillNoInTasks(CommandContext commandContext, Long processInstanceId, String newBillNo, String oldBillNo) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List<TaskEntity> tasks = taskEntityManager.findTasksByProcessInstanceId(processInstanceId);
        if (CollectionUtil.isNotEmpty(tasks)) {
            ArrayList<Object[]> subjectParams = new ArrayList<Object[]>();
            ArrayList<Object[]> params = new ArrayList<Object[]>(tasks.size());
            for (TaskEntity taskEntity : tasks) {
                Long id = taskEntity.getId();
                ILocaleString subject = taskEntity.getSubject();
                this.builderLocaleValues(newBillNo, oldBillNo, subject, id, subjectParams);
                params.add(new Object[]{subject.toString(), newBillNo, id});
            }
            this.batchUpdateLocaleData(taskEntityManager, subjectParams, FSUBJECT, "T_WF_TASK_L");
            if (CollectionUtil.isNotEmpty(params)) {
                String sql = "UPDATE T_WF_TASK SET FSUBJECT = ? , FBILLNO = ? WHERE FID= ?";
                taskEntityManager.addBatchSQLInfo(new BatchSQLInfo(sql, params, 100));
            }
        }
    }

    private void updateBillNoInExecutions(CommandContext commandContext, Long processInstanceId, String newBillNo, String oldBillNo) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> executions = executionEntityManager.findActiveExecutionsByProcessInstanceId(processInstanceId);
        if (CollectionUtil.isNotEmpty(executions)) {
            ArrayList<Object[]> subjectParams = new ArrayList<Object[]>();
            ArrayList<Object[]> nameParams = new ArrayList<Object[]>();
            ArrayList<Object[]> params = new ArrayList<Object[]>(executions.size());
            for (ExecutionEntity execution : executions) {
                Long id = execution.getId();
                ILocaleString subject = execution.getSubject();
                ILocaleString name = execution.getName();
                this.builderLocaleValues(newBillNo, oldBillNo, subject, id, subjectParams);
                this.builderLocaleValues(newBillNo, oldBillNo, name, id, nameParams);
                params.add(new Object[]{subject.toString(), name.toString(), newBillNo, id});
            }
            this.batchUpdateLocaleData(executionEntityManager, subjectParams, FSUBJECT, "T_WF_EXECUTION_L");
            this.batchUpdateLocaleData(executionEntityManager, nameParams, FNAME, "T_WF_EXECUTION_L");
            if (CollectionUtil.isNotEmpty(params)) {
                String sql = "UPDATE T_WF_EXECUTION SET FSUBJECT = ? , FNAME = ? , FBILLNO = ? WHERE FID= ?";
                executionEntityManager.addBatchSQLInfo(new BatchSQLInfo(sql, params, 100));
            }
        }
    }

    private void builderLocaleValues(String newBillNo, String oldBillNo, ILocaleString localeValue, Long id, List<Object[]> params) {
        if (WfUtils.isNotEmpty(localeValue)) {
            Lang[] supportLangs;
            for (Lang lang : supportLangs = WfUtils.getSupportLangs()) {
                String langKey = lang.toString();
                String localeStr = (String)localeValue.get((Object)langKey);
                if (!WfUtils.isNotEmpty(localeStr)) continue;
                localeStr = localeStr.replace(oldBillNo, newBillNo);
                localeValue.setItem(langKey, (Object)localeStr);
                params.add(new Object[]{localeStr, id, langKey});
            }
        }
    }

    private void batchUpdateLocaleData(EntityManager manger, List<Object[]> params, String updateField, String tableName) {
        if (CollectionUtil.isNotEmpty(params) && WfUtils.isNotEmpty(updateField) && WfUtils.isNotEmpty(tableName)) {
            String sql = "UPDATE " + tableName + " SET " + updateField + " = ? WHERE FID= ? AND FLOCALEID = ? ";
            manger.addBatchSQLInfo(new BatchSQLInfo(sql, params, 500));
        }
    }
}

