/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFTaskException;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;

    public NeedsActiveTaskCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new WFIllegalArgumentException("taskId is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
            if (hiTask != null && hiTask.getEndTime() != null) {
                throw new WFTaskException(WFErrorCode.taskCompleted());
            }
            throw new WFTaskException(WFErrorCode.taskNotFound());
        }
        if (task.isSuspended()) {
            throw new WFEngineException(this.getSuspendedTaskException());
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskException() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u5904\u7406\u3002", (String)"NeedsActiveTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

