/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.basedata.DelegateSettingInfo;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.HistoricDelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.HistoricDelegateSettingEntityManager;
import kd.bos.workflow.service.WorkflowService;

public class SaveAndEnableDelegateSettingsCmd
implements Command<Map<String, Object>> {
    private static final Log logger = LogFactory.getLog(SaveAndEnableDelegateSettingsCmd.class);
    private static final String EXISTSMUTUALDELEGATE = "bos.wf.existsMutualDelegate";
    private static final String EXISTSDELEGATERING = "bos.wf.existsDelegateRing";
    private static final int IDLENGTH = 19;
    private static final String SCOPE_BILL = "2";
    private static final String SCOPER_ALL = "3";
    private List<DelegateSettingInfo> delegateSettings;

    public SaveAndEnableDelegateSettingsCmd(List<DelegateSettingInfo> delegateSettings) {
        this.delegateSettings = delegateSettings;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (WfUtils.isEmptyForCollection(this.delegateSettings)) {
            return result;
        }
        ArrayList<Long> successSettings = new ArrayList<Long>(this.delegateSettings.size());
        HashMap<Long, String> failSettings = new HashMap<Long, String>(this.delegateSettings.size());
        failSettings.putAll(this.check());
        this.saveDelegateSetting(successSettings, failSettings);
        this.enableDelegateSetting(successSettings, failSettings);
        if (WfUtils.isNotEmptyForCollection(successSettings)) {
            result.put("successIds", successSettings);
        }
        result.put("successCount", successSettings.size());
        if (WfUtils.isNotEmptyForMap(failSettings)) {
            JSONArray array = new JSONArray();
            failSettings.forEach((id, desc) -> {
                JSONObject tmp = new JSONObject();
                tmp.put("id", id);
                tmp.put("desc", desc);
                array.add((Object)tmp);
            });
            result.put("errorInfos", array);
        }
        result.put("failedCount", failSettings.size());
        return result;
    }

    private void enableDelegateSetting(List<Long> successSettings, Map<Long, String> failSettings) {
        DelegateSettingEntityManager delegateSettingEntityManager = Context.getCommandContext().getDelegateSettingEntityManager();
        StringJoiner enableDelegateSettingIds = new StringJoiner("\uff0c");
        this.delegateSettings.stream().filter(x -> successSettings.contains(x.getId())).forEach(setting -> {
            String existDelegateRing = SaveAndEnableDelegateSettingsCmd.existDelegateRing(setting.getId());
            if (WfUtils.isNotEmpty(existDelegateRing)) {
                successSettings.remove(setting.getId());
                failSettings.put(setting.getId(), existDelegateRing);
            } else if (setting.isStatus()) {
                delegateSettingEntityManager.enableDelegateSetting(setting.getId());
                enableDelegateSettingIds.add(setting.getId().toString());
            }
        });
        if (enableDelegateSettingIds.length() > 0) {
            WfUtils.addOpLog("wf_delegatesetting", "enable", ResManager.getLocaleString((String)"\u59d4\u6258\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_18", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), new MultiLangEnumBridge("\u6210\u529f\u542f\u7528id\u4e3a%s\u7684\u59d4\u6258", "WorkflowDelegateSettingListPlugin_19", "bos-wf-formplugin"), enableDelegateSettingIds);
        }
    }

    private void saveDelegateSetting(List<Long> successSettings, Map<Long, String> failSettings) {
        CommandContext commandContext = Context.getCommandContext();
        DelegateSettingEntityManager delegateSettingEntityManager = commandContext.getDelegateSettingEntityManager();
        HistoricDelegateSettingEntityManager historicDelegateSettingEntityManager = commandContext.getHistoricDelegateSettingEntityManager();
        List<Long> delegateIds = this.delegateSettings.stream().map(DelegateSettingInfo::getId).filter(id -> !failSettings.containsKey(id)).collect(Collectors.toList());
        Map<Long, DelegateSettingEntity> entitys = delegateSettingEntityManager.findByIds(delegateIds);
        this.delegateSettings.stream().filter(x -> WfUtils.isNotEmpty(x.getId()) && !failSettings.containsKey(x.getId())).forEach(setting -> {
            DelegateSettingEntity delegateSettingEntity = (DelegateSettingEntity)entitys.get(setting.getId());
            try {
                DelegateSettingEntity newDelegateSettingEntity = this.buildDelegateSettingEntity((DelegateSettingInfo)setting, delegateSettingEntity);
                if (delegateSettingEntity == null) {
                    delegateSettingEntityManager.insert(newDelegateSettingEntity);
                } else {
                    delegateSettingEntityManager.update(newDelegateSettingEntity);
                }
                historicDelegateSettingEntityManager.insert(this.buildHiDelegateSettingEntity(newDelegateSettingEntity));
                successSettings.add(setting.getId());
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
                failSettings.put(setting.getId(), ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SaveDelegateSettingsCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        });
    }

    private HistoricDelegateSettingEntity buildHiDelegateSettingEntity(DelegateSettingEntity newDelegateSettingEntity) {
        HistoricDelegateSettingEntity hiDelegate = (HistoricDelegateSettingEntity)Objects.requireNonNull(Context.getCommandContext()).getHistoricDelegateSettingEntityManager().create();
        hiDelegate.setDelegateId(newDelegateSettingEntity.getId());
        hiDelegate.setAssignorId(newDelegateSettingEntity.getAssignorId());
        hiDelegate.setTrusteeId(newDelegateSettingEntity.getTrusteeId());
        hiDelegate.setScope(newDelegateSettingEntity.getScope());
        hiDelegate.setEntraBillId(newDelegateSettingEntity.getEntraBillId());
        hiDelegate.setStartTime(newDelegateSettingEntity.getStartTime());
        hiDelegate.setEndTime(newDelegateSettingEntity.getEndTime());
        hiDelegate.setSendMsgToAssignor(newDelegateSettingEntity.isSendMsgToAssignor());
        hiDelegate.setReceiveTodoTask(newDelegateSettingEntity.isReceiveTodoTask());
        hiDelegate.setStatus(newDelegateSettingEntity.getStatus());
        hiDelegate.setSource(newDelegateSettingEntity.getSource());
        return hiDelegate;
    }

    private DelegateSettingEntity buildDelegateSettingEntity(DelegateSettingInfo settingInfo, DelegateSettingEntity oldDelegateSettingEntity) {
        DelegateSettingEntity newDelegateSettingEntity = Optional.ofNullable(oldDelegateSettingEntity).orElseGet(() -> (DelegateSettingEntity)Objects.requireNonNull(Context.getCommandContext()).getDelegateSettingEntityManager().create());
        newDelegateSettingEntity.setId(settingInfo.getId());
        newDelegateSettingEntity.setAssignorId(settingInfo.getAssignorid());
        newDelegateSettingEntity.setTrusteeId(settingInfo.getTrusteeid());
        newDelegateSettingEntity.setScope(WfUtils.isNotEmpty(settingInfo.getScope()) ? settingInfo.getScope() : SCOPER_ALL);
        if (WfUtils.isNotEmpty(settingInfo.getScope()) && SCOPE_BILL.equals(settingInfo.getScope())) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entitymeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)settingInfo.getEntrabillnumber())});
            newDelegateSettingEntity.setEntraBillId(bill.getString("id"));
        } else {
            newDelegateSettingEntity.setEntraBillId(null);
        }
        newDelegateSettingEntity.setStartTime(settingInfo.getStarttime());
        newDelegateSettingEntity.setEndTime(settingInfo.getEndtime());
        newDelegateSettingEntity.setSendMsgToAssignor(settingInfo.isSendmsgtoassignor());
        newDelegateSettingEntity.setReceiveTodoTask(settingInfo.isReceivetodotask());
        newDelegateSettingEntity.setStatus(settingInfo.isStatus() ? "1" : "0");
        newDelegateSettingEntity.setSource(settingInfo.getSource());
        return newDelegateSettingEntity;
    }

    private Map<Long, String> check() {
        HashMap<Long, String> failResult = new HashMap<Long, String>(this.delegateSettings.size());
        ArrayList userIds = new ArrayList(this.delegateSettings.size());
        this.delegateSettings.stream().filter(Objects::nonNull).forEach(delegateSetting -> {
            if (WfUtils.isEmpty(delegateSetting.getId())) {
                failResult.put(0L, ResManager.loadKDString((String)"\u59d4\u6258ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaveDelegateSettingsCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isEmpty(delegateSetting.getAssignorid())) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaveDelegateSettingsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isEmpty(delegateSetting.getTrusteeid())) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u53d7\u6258\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaveDelegateSettingsCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (delegateSetting.getStarttime() == null) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaveDelegateSettingsCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (delegateSetting.getEndtime() == null) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaveDelegateSettingsCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (String.valueOf(delegateSetting.getId()).length() != 19) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258ID\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"SaveDelegateSettingsCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (delegateSetting.getAssignorid().equals(delegateSetting.getTrusteeid())) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u548c\u53d7\u6258\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba\u3002", (String)"SaveDelegateSettingsCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (delegateSetting.getStarttime().getTime() < WfUtils.now().getTime()) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SaveDelegateSettingsCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (delegateSetting.getStarttime().getTime() > delegateSetting.getEndtime().getTime()) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u59d4\u6258\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SaveDelegateSettingsCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isNotEmpty(delegateSetting.getScope()) && !SCOPE_BILL.equals(delegateSetting.getScope()) && !SCOPER_ALL.equals(delegateSetting.getScope())) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u65b9\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SaveDelegateSettingsCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            if (SCOPE_BILL.equals(delegateSetting.getScope()) && WfUtils.isEmpty(delegateSetting.getEntrabillnumber())) {
                failResult.put(delegateSetting.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u65b9\u5f0f\u4e3a\u201c2\u201d\uff0c\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SaveDelegateSettingsCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
            userIds.add(delegateSetting.getAssignorid());
            userIds.add(delegateSetting.getTrusteeid());
        });
        if (!userIds.isEmpty()) {
            DynamicObject[] existUsers;
            HashMap<Long, Long> users = new HashMap<Long, Long>(userIds.size());
            for (DynamicObject existUser : existUsers = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)})) {
                users.put(existUser.getLong("id"), existUser.getLong("id"));
            }
            this.delegateSettings.stream().filter(x -> !failResult.containsKey(x.getId())).forEach(tmp -> {
                if (!users.containsKey(tmp.getAssignorid())) {
                    failResult.put(tmp.getId(), ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u4e0d\u5b58\u5728\u3002", (String)"SaveDelegateSettingsCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]));
                    return;
                }
                if (!users.containsKey(tmp.getTrusteeid())) {
                    failResult.put(tmp.getId(), ResManager.loadKDString((String)"\u53d7\u6258\u4eba\u4e0d\u5b58\u5728\u3002", (String)"SaveDelegateSettingsCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            });
        }
        return failResult;
    }

    private static String existDelegateRing(Long curDelegateId) {
        block2: {
            try {
                CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutor();
                CommandConfig defaultConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                commandExecutor.execute(defaultConfig, commandContext -> {
                    WorkflowService wfService = WfUtils.getWfService();
                    ManagementService managementService = wfService.getManagementService();
                    managementService.validateDelegateSetting(curDelegateId, null, null);
                    return null;
                });
            }
            catch (KDBizException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (!EXISTSMUTUALDELEGATE.equals(errorCode.getCode()) && !EXISTSDELEGATERING.equals(errorCode.getCode())) break block2;
                return errorCode.getMessage();
            }
        }
        return null;
    }
}

