/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class SaveOrUpdateDynResourceCmd
implements Command<String> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long proinstId;
    private String userId;
    private DynamicResourceEntity resource;
    private List<Long> proinstIds = null;

    public SaveOrUpdateDynResourceCmd(Long proinstId, DynamicResourceEntity resource) {
        this.proinstId = proinstId;
        this.resource = resource;
    }

    public SaveOrUpdateDynResourceCmd(List<Long> proinstIds, String userId) {
        this.proinstIds = proinstIds;
        this.userId = userId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.proinstIds != null && this.resource == null) {
            QFilter filter = new QFilter("processInstanceId", "in", this.proinstIds).and("scope", "=", (Object)false).and("active", "=", (Object)true);
            List executions = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{filter});
            List<DynamicResourceEntity> resources = commandContext.getDynamicResourceEntityManager().findByProinstIds(this.proinstIds);
            ArrayList<DynamicResourceEntity> willUpdateResource = new ArrayList<DynamicResourceEntity>();
            ArrayList<DynamicResourceEntity> willInsertResource = new ArrayList<DynamicResourceEntity>();
            for (ExecutionEntity e : executions) {
                String activityId = e.getActivityId();
                Long proinstId = e.getProcessInstanceId();
                FlowElement currentElement = this.setExecutionEntity(commandContext, e, activityId);
                if (!(currentElement instanceof UserTask)) continue;
                Iterator<DynamicResourceEntity> iter = resources.iterator();
                DynamicResourceEntity rs = null;
                while (iter.hasNext()) {
                    DynamicResourceEntity s = iter.next();
                    if (!s.getActivityId().equals(activityId) || proinstId.longValue() != s.getProcessInstanceId().longValue()) continue;
                    rs = s;
                    iter.remove();
                    break;
                }
                if (rs != null && WfUtils.isNotEmpty(rs.getContent().getLocaleValue())) {
                    String modelJson = rs.getContent().getLocaleValue();
                    BpmnModel sbpmnModel = null;
                    try {
                        JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
                        sbpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
                        UserTask userTask = (UserTask)sbpmnModel.getMainProcess().getFlowElement(activityId);
                        if (userTask != null) {
                            if (userTask.getParticipant() != null) {
                                List<ParticipantModelEntityImpl> participants = userTask.getParticipant().getParticipant();
                                if (CollectionUtil.isNotEmpty(participants)) {
                                    participants.get(0).setValue(this.userId);
                                }
                            } else {
                                ParticipatantModel pm = SaveOrUpdateDynResourceCmd.createParticipantModel(userTask, this.userId);
                                userTask.setParticipant(pm);
                            }
                        }
                        modelJson = GraphCodecUtils.convertBpmnModelToJSON(sbpmnModel);
                        willUpdateResource.add(rs);
                    }
                    catch (IOException ie) {
                        this.logger.error(ie.getMessage(), (Throwable)ie);
                    }
                    continue;
                }
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(e.getProcessDefinitionId(), e.getProcessInstanceId());
                rs = new DynamicResourceEntityImpl();
                rs.setName("dyn." + model.getMainProcess().getNumber() + ".bpmn20.json");
                rs.setProcessDefineId(e.getProcessDefinitionId());
                rs.setProcessInstanceId(e.getProcessInstanceId());
                rs.setActivityId(activityId);
                Process dynProcess = new Process();
                BpmnModel sbpmnModel = new BpmnModel();
                sbpmnModel.addProcess(dynProcess);
                sbpmnModel.addGraphicInfo(activityId, model.getLocationMap().get(activityId));
                dynProcess.addFlowElement(SaveOrUpdateDynResourceCmd.createUserTask(activityId, model, this.userId));
                String content = GraphCodecUtils.convertBpmnModelToJSON(sbpmnModel);
                rs.setContent((ILocaleString)new LocaleString(content));
                rs.setType("dynParticipant");
                willInsertResource.add(rs);
            }
            if (!willUpdateResource.isEmpty()) {
                for (DynamicResourceEntity i : willUpdateResource) {
                    commandContext.getDynamicResourceEntityManager().update(i);
                    this.removeCache(i.getProcessInstanceId());
                }
            }
            if (!willInsertResource.isEmpty()) {
                for (DynamicResourceEntity i : willInsertResource) {
                    commandContext.getDynamicResourceEntityManager().insert(i);
                    this.removeCache(i.getProcessInstanceId());
                }
            }
        } else {
            this.doSingle(commandContext);
        }
        return null;
    }

    private void doSingle(CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.proinstId);
        String activityId = this.resource.getActivityId();
        this.setExecutionEntity(commandContext, executionEntity, activityId);
        if (WfUtils.isNotEmpty(this.resource.getId())) {
            commandContext.getDynamicResourceEntityManager().update(this.resource);
        } else {
            commandContext.getDynamicResourceEntityManager().insert(this.resource);
        }
        this.removeCache(this.proinstId);
    }

    private FlowElement setExecutionEntity(CommandContext commandContext, ExecutionEntity executionEntity, String activityId) {
        List dynamicParticipantList;
        String dynamicParticipantVariable;
        String elementType;
        FlowElement flowElement = executionEntity.getCurrentFlowElement();
        if (flowElement == null) {
            Process process = ProcessDefinitionUtil.getProcess(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId());
            QFilter filter1 = new QFilter("businesskey", "=", (Object)executionEntity.getBusinessKey());
            QFilter filter2 = new QFilter("errortype", "=", (Object)"nullParticipant");
            List deadLetterJobEntity = commandContext.getDeadLetterJobEntityManager().findByQueryFilters(new QFilter[]{filter1, filter2});
            flowElement = process.getFlowElement(((DeadLetterJobEntity)deadLetterJobEntity.get(0)).getElementId());
        }
        if (WfUtils.isAuditTypeNode(elementType = flowElement.getType()) && WfUtils.isNotEmpty(dynamicParticipantVariable = (String)executionEntity.getVariable("dynParticipant")) && (dynamicParticipantList = SerializationUtils.fromJsonStringToList((String)dynamicParticipantVariable, Map.class)) != null) {
            ListIterator dynamicParticipantIterator = dynamicParticipantList.listIterator();
            while (dynamicParticipantIterator.hasNext()) {
                Map dynamicParticipant = (Map)dynamicParticipantIterator.next();
                if (!dynamicParticipant.containsValue(activityId)) continue;
                dynamicParticipantIterator.remove();
            }
            if (dynamicParticipantList.size() > 0) {
                executionEntity.setVariable("dynParticipant", SerializationUtils.toJsonString((Object)dynamicParticipantList));
            } else {
                executionEntity.removeVariable("dynParticipant");
            }
        }
        return flowElement;
    }

    private void removeCache(Long procInstId) {
        ProcessDefinitionUtil.removeBPMNModel(procInstId);
        WfCacheHelper.removeCachedDynamicProcessInstance(procInstId);
    }

    public static UserTask createUserTask(String activityId, BpmnModel bpmnModel, String userId) {
        UserTask userTask = new UserTask();
        userTask.setId(activityId);
        userTask.setNumber(bpmnModel.getFlowElement(activityId).getNumber());
        userTask.setType("UserTask");
        userTask.setParticipant(SaveOrUpdateDynResourceCmd.createParticipantModel(userTask, userId));
        return userTask;
    }

    public static ParticipatantModel createParticipantModel(UserTask userTask, String uid) {
        ParticipantModelEntityImpl p = new ParticipantModelEntityImpl();
        p.setProperty("participant");
        p.setValue(uid);
        p.setType("person");
        LinkedHashMap<String, List<ExtensionAttribute>> attributes = new LinkedHashMap<String, List<ExtensionAttribute>>();
        ArrayList<ExtensionAttribute> eaes = new ArrayList<ExtensionAttribute>();
        ExtensionAttribute ea = new ExtensionAttribute();
        ea.setName("openpagebyformid");
        ea.setValue("wf_part_person");
        eaes.add(ea);
        attributes.put("openpagebyformid", eaes);
        ArrayList<ExtensionAttribute> eaees = new ArrayList<ExtensionAttribute>();
        ExtensionAttribute eae = new ExtensionAttribute();
        eae.setName("selectedType");
        eae.setValue("person");
        eaees.add(eae);
        attributes.put("selectedType", eaees);
        p.setAttributes(attributes);
        ParticipatantModel participatantModel = new ParticipatantModel();
        ArrayList<ParticipantModelEntityImpl> participatantModels = new ArrayList<ParticipantModelEntityImpl>();
        participatantModels.add(p);
        participatantModel.setParticipant(participatantModels);
        return participatantModel;
    }
}

