/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.api.SuspendInfo;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.engine.WfSuspendUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.SuspendProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;

public class SuspendOrActiveProcessCmd
implements Command<Void> {
    protected Long processInstanceId;
    protected boolean suspend;
    protected final ILocaleString suspendReason;
    protected String errorType = null;
    protected String fields = String.format("%s, %s, %s", "suspensionState", "activityId", "superExecutionId");

    public SuspendOrActiveProcessCmd(Long processInstanceId, boolean suspend) {
        this.processInstanceId = processInstanceId;
        this.suspend = suspend;
        this.suspendReason = WfUtils.getPromptWordLocaleString("\u88ab\u7236\u6d41\u7a0b\u624b\u52a8\u6302\u8d77", "SuspendOrActivateSubProcessInstanceCmd_1", "bos-wf-engine");
    }

    public SuspendOrActiveProcessCmd(Long processInstanceId, boolean suspend, ILocaleString suspendReason, String errorType) {
        this.processInstanceId = processInstanceId;
        this.suspend = suspend;
        this.suspendReason = suspendReason;
        this.errorType = errorType;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity superExecution = ((ExecutionEntity)new GetSingleEntityCmd(this.processInstanceId, "wf_execution", this.fields).execute(commandContext)).getSuperExecution();
        if (this.suspend) {
            this.suspendProcess(commandContext, superExecution);
            this.afterSuspendOrActiveProcess(commandContext, ExtItfCallerType.AFTERSUSPENDPROCESS);
            this.sendEvent(commandContext, "wf.AfterProcessManSuspendEvent");
        } else {
            this.saveOperationLog(commandContext);
            this.activeProcess(commandContext, superExecution);
            this.afterSuspendOrActiveProcess(commandContext, ExtItfCallerType.AFTERACTIVEPROCESS);
            this.sendEvent(commandContext, "wf.AfterProcessManActivateEvent");
        }
        return null;
    }

    private void afterSuspendOrActiveProcess(CommandContext commandContext, ExtItfCallerType type) {
        String className = WfSuspendUtil.getSuspendConfigInfo(type);
        if (WfUtils.isNotEmpty(className)) {
            SuspendInfo suspendInfo = this.buildSuspendInfo(commandContext);
            WfSuspendUtil.invokeExtItfMethod(suspendInfo, type, className);
        }
    }

    private void sendEvent(CommandContext commandContext, String eventCode) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            return;
        }
        HistoricProcessInstanceEntity hiEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
        List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.processInstanceId);
        String currentNodeId = "";
        if (executionList != null && executionList.size() > 0) {
            HashMap currentNodeIdMap = new HashMap(8);
            StringBuilder currentNodeIdBd = new StringBuilder();
            for (ExecutionEntity executionEntity : executionList) {
                if (currentNodeIdMap.containsKey(executionEntity.getActivityId())) continue;
                currentNodeIdMap.put(executionEntity.getActivityId(), null);
                currentNodeIdBd.append(executionEntity.getActivityId()).append(",");
            }
            currentNodeId = currentNodeIdBd.toString();
            currentNodeId = currentNodeId.substring(0, currentNodeId.length() - 1);
            currentNodeIdMap = null;
        }
        if (hiEntity != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("currentNodeId", currentNodeId);
            new EventTriggerCmd(eventCode, hiEntity, map).execute(commandContext);
        }
    }

    private SuspendInfo buildSuspendInfo(CommandContext commandContext) {
        HistoricProcessInstanceEntity hiEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
        SuspendInfo suspendInfo = new SuspendInfo();
        suspendInfo.setProcessInstanceId(this.processInstanceId);
        suspendInfo.setProcessDefinitionId(hiEntity.getProcessDefinitionId());
        suspendInfo.setBusinessKey(hiEntity.getBusinessKey());
        suspendInfo.setEntityNumber(hiEntity.getEntitynumber());
        suspendInfo.setErrMsg(this.suspendReason.getLocaleValue());
        suspendInfo.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        return suspendInfo;
    }

    private void activeProcess(CommandContext commandContext, ExecutionEntity superExecution) {
        new ActivateProcessInstanceCmd(this.processInstanceId).execute(commandContext);
        if (superExecution != null && ManagementConstants.SUSPENDED.getStateCode().equals(superExecution.getSuspensionState()) && superExecution.getCurrentFlowElement() instanceof CallActivity) {
            new ActivateProcessInstanceCmd(superExecution.getProcessInstanceId()).execute(commandContext);
        } else {
            this.activateSubProcessInstance(commandContext);
        }
    }

    private void suspendProcess(CommandContext commandContext, ExecutionEntity superExecution) {
        if (WfUtils.isEmpty(this.errorType)) {
            new SuspendProcessInstanceCmd(this.processInstanceId).execute(commandContext);
        } else {
            new SuspendProcessInstanceCmd(this.processInstanceId, this.suspendReason, this.errorType).execute(commandContext);
        }
        if (superExecution != null && ManagementConstants.ACTIVE.getStateCode().equals(superExecution.getSuspensionState()) && superExecution.getCurrentFlowElement() instanceof CallActivity) {
            new SuspendProcessInstanceCmd(superExecution.getProcessInstanceId()).execute(commandContext);
        } else {
            this.suspendSubProcessInstance(commandContext);
        }
    }

    private void suspendSubProcessInstance(CommandContext commandContext) {
        List<HistoricProcessInstanceEntity> subProcessInstances = this.getSubProcessInstances(commandContext);
        if (subProcessInstances != null && !subProcessInstances.isEmpty()) {
            for (HistoricProcessInstanceEntity subProcess : subProcessInstances) {
                new SuspendProcessInstanceCmd(subProcess.getId(), this.suspendReason).execute(commandContext);
            }
        }
    }

    private void activateSubProcessInstance(CommandContext commandContext) {
        List<HistoricProcessInstanceEntity> subProcessInstances = this.getSubProcessInstances(commandContext);
        if (subProcessInstances != null && !subProcessInstances.isEmpty()) {
            for (HistoricProcessInstanceEntity subProcess : subProcessInstances) {
                new ActivateProcessInstanceCmd(subProcess.getId()).execute(commandContext);
            }
        }
    }

    private List<HistoricProcessInstanceEntity> getSubProcessInstances(CommandContext commandContext) {
        HistoricProcessInstanceEntityManager procInstEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
        EntityQueryBuilder queryBuilder = procInstEntityManager.createQueryBuilder();
        queryBuilder.addFilter("superProcessInstanceId", this.processInstanceId).addFilter("endTime", "is null", null);
        return procInstEntityManager.findByQueryBuilder(queryBuilder);
    }

    private void saveOperationLog(CommandContext commandContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        WfOperationLogUtil.recordOperationLogByIdAndType(commandContext, operationLog, this.processInstanceId, "suspendCancel");
    }
}

