/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessDefinitionStateCmd;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import kd.bos.workflow.engine.impl.cmd.SuspendProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.runtime.ProcessInstance;

public class SuspendProcessDefinitionCmd
extends AbstractSetProcessDefinitionStateCmd {
    public SuspendProcessDefinitionCmd(ProcessDefinitionEntity processDefinitionEntity, boolean includeProcessInstances, Date executionDate) {
        super(processDefinitionEntity, executionDate);
    }

    public SuspendProcessDefinitionCmd(Long processDefinitionId, String processDefinitionKey, Date suspensionDate) {
        super(processDefinitionId, processDefinitionKey, suspensionDate);
    }

    @Override
    protected SuspensionState getProcessDefinitionSuspensionState() {
        return ManagementConstants.SUSPENDED;
    }

    @Override
    public List<ProcessDefinitionEntity> execute(CommandContext commandContext) {
        Object result = super.execute(commandContext);
        Long procDefId = this.processDefinitionId;
        if (procDefId == null) {
            procDefId = this.processDefinitionEntity.getId();
        }
        this.deleteProcessInfosAndModelChangeLogs(commandContext, procDefId);
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Long> params = new HashMap<String, Long>(1);
            params.put("processDefinitionId", procDefId);
            new EventTriggerCmd("wf.AfterSuspendProcessEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        final Long definitionId = procDefId;
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

            @Override
            public void closed(CommandContext commandContext) {
                try {
                    NodeLifecycleUtil.executeLifecycleSuspendListener(definitionId);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        });
        return result;
    }

    private void deleteProcessInfosAndModelChangeLogs(CommandContext commandContext, Long procDefId) {
        try {
            if (BatchSettingUtil.isProcessInfoCanBeDeleted(commandContext, procDefId, null)) {
                commandContext.getProcessInfoEntityManager().deleteProcessInfoByProcDefId(procDefId);
                commandContext.getModelDataChangeLogEntityManager().deleteChangeLogsByProcDefId(procDefId);
            }
        }
        catch (Exception e) {
            logger.error(String.format("deleteProcessInfosAndModelChangeLogs failed! %s %s", procDefId, WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Override
    protected String getOperationLogName() {
        return WFMultiLangConstants.getDisableProcessName();
    }

    @Override
    protected MultiLangEnumBridge getOperationNameBridge() {
        return WFMultiLangConstants.getDisableProcessBridgeName();
    }

    @Override
    protected String getDelayedExecutionJobHandlerType() {
        return null;
    }

    @Override
    protected AbstractSetProcessInstanceStateCmd getProcessInstanceChangeStateCmd(ProcessInstance processInstance) {
        return new SuspendProcessInstanceCmd(processInstance.getId());
    }
}

