/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;

public class SuspendProcessInstanceCmd
extends AbstractSetProcessInstanceStateCmd {
    protected final ILocaleString suspendReason;
    protected String errorType = null;

    public SuspendProcessInstanceCmd(Long executionId) {
        super(executionId);
        this.suspendReason = WfUtils.getPromptWordLocaleString("\u624b\u52a8\u6302\u8d77", "SuspendProcessInstanceCmd_1", "bos-wf-engine");
    }

    public SuspendProcessInstanceCmd(Long processInstanceId, ILocaleString suspendReason) {
        super(processInstanceId);
        this.suspendReason = suspendReason;
    }

    public SuspendProcessInstanceCmd(Long processInstanceId, ILocaleString suspendReason, String errorType) {
        this(processInstanceId, suspendReason);
        this.errorType = errorType;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.saveOperationLog(commandContext);
        super.execute(commandContext);
        commandContext.getDurationDetailEntityManager().insertDurationDetail(this.processInstanceId, this.suspendReason, SuspendType.MANUALSUSPEND.getCode(), this.errorType);
        return null;
    }

    @Override
    protected SuspensionState getNewState() {
        return ManagementConstants.SUSPENDED;
    }

    private void saveOperationLog(CommandContext commandContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        operationLog.setNOpinion(this.suspendReason);
        WfOperationLogUtil.recordOperationLogByIdAndType(commandContext, operationLog, this.processInstanceId, "suspend");
    }
}

