/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFException;

public class UpdateBpmnModelPropertysCmd
implements Command<Void> {
    private static Set<String> whiteList = new HashSet<String>(10);
    private Long procInstId;
    private String actId;
    private Map<String, Map<String, Object>> params;

    public UpdateBpmnModelPropertysCmd(Long procInstId, String actId, Map<String, Map<String, Object>> params) {
        this.procInstId = procInstId;
        this.actId = actId;
        this.params = params;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processExecution = commandContext.getExecutionEntityManager().findProcessInstanceById(this.procInstId);
        if (processExecution == null) {
            throw new WFException(String.format("processExecution is null may have ended, procInstId=%s", this.procInstId));
        }
        Process process = ProcessDefinitionUtil.getProcess(null, this.procInstId);
        if (process == null) {
            throw new WFException(String.format("process is null, procInstId=%s", this.procInstId));
        }
        FlowElement flowElement = process.getFlowElement(this.actId);
        if (flowElement == null) {
            throw new WFException(String.format("flowElement is null, procInstId=%s, actId=%s", this.procInstId, this.actId));
        }
        if (WfUtils.isEmptyForMap(this.params)) {
            return null;
        }
        HashSet<String> notAllowChangeProperties = new HashSet<String>(10);
        for (Map<String, Object> param : this.params.values()) {
            for (String key : param.keySet()) {
                if (whiteList.contains(key)) continue;
                notAllowChangeProperties.add(key);
            }
        }
        StringJoiner notAllowChangePropertiesStr = new StringJoiner(",");
        if (WfUtils.isNotEmptyForCollection(notAllowChangeProperties)) {
            Set<String> allowChangeProperties = WfConfigurationUtil.getAllowChangeProperties();
            for (String property : notAllowChangeProperties) {
                if (allowChangeProperties.contains(property)) continue;
                notAllowChangePropertiesStr.add(property);
            }
        }
        if (notAllowChangePropertiesStr.length() > 0) {
            throw new WFException(String.format("properties[%s] is not allow change", notAllowChangePropertiesStr.toString()));
        }
        DynamicResourceEntityManager manager = commandContext.getDynamicResourceEntityManager();
        DynamicResourceEntity dynResource = manager.findByActivityIdAndType(this.procInstId, this.actId, "dynNodeProperty");
        Object content = dynResource != null ? dynResource.getContent() : new LocaleString();
        boolean isChanged = false;
        for (Map.Entry<String, Map<String, Object>> param : this.params.entrySet()) {
            String lang = param.getKey();
            String newContent = WfUtils.isEmpty((String)content.get((Object)lang)) ? this.initContent(lang, flowElement, null, param.getValue()) : this.initContent(lang, null, (String)content.get((Object)lang), param.getValue());
            if (!WfUtils.isNotEmpty(newContent)) continue;
            content.setItem(lang, (Object)newContent);
            isChanged = true;
        }
        if (isChanged) {
            if (dynResource != null) {
                dynResource.setContent((ILocaleString)content);
                manager.update(dynResource);
            } else {
                dynResource = (DynamicResourceEntity)manager.create();
                dynResource.setContent((ILocaleString)content);
                dynResource.setActivityId(this.actId);
                dynResource.setProcessInstanceId(this.procInstId);
                dynResource.setName("dyn." + process.getNumber() + ".bpmn20.json");
                dynResource.setType("dynNodeProperty");
                HistoricProcessInstanceEntityManager hisProcessInstanceMgr = commandContext.getHistoricProcessInstanceEntityManager();
                HistoricProcessInstanceEntity procInstance = (HistoricProcessInstanceEntity)hisProcessInstanceMgr.findById(this.procInstId, "processDefinitionId");
                if (procInstance != null) {
                    dynResource.setProcessDefineId(procInstance.getProcessDefinitionId());
                }
                manager.insert(dynResource);
            }
            this.clearCacheAndReload(commandContext, processExecution);
        }
        return null;
    }

    private Object getPropValue(FlowElement flowElement, JSONObject propertyJSON, String propName) {
        if (flowElement == null) {
            return propertyJSON.get((Object)propName);
        }
        return flowElement.getPropertyValue(propName);
    }

    private String initContent(String lang, FlowElement flowElement, String oldContent, Map<String, Object> params) {
        String originalContent;
        JSONObject newProperties = new JSONObject();
        if (flowElement != null) {
            BpmnModel newBpmnModel = new BpmnModel();
            Process newProcess = new Process();
            newBpmnModel.addProcess(newProcess);
            FlowElement newFlowElement = flowElement.clone();
            newProcess.addFlowElement(newFlowElement);
            originalContent = GraphCodecUtils.convertBpmnModelToJSON(newBpmnModel);
        } else {
            originalContent = oldContent;
        }
        JSONObject contentJSON = JSON.parseObject((String)originalContent);
        JSONArray childShapes = contentJSON.getJSONArray("childShapes");
        JSONObject nodeJSON = childShapes.getJSONObject(0);
        JSONObject propertyJSON = nodeJSON.getJSONObject("properties");
        if (flowElement == null) {
            newProperties = propertyJSON;
        }
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String propName = param.getKey();
            Object oldValue = this.getPropValue(flowElement, propertyJSON, propName);
            Object newValue = param.getValue();
            if (oldValue != null) {
                if (oldValue instanceof ILocaleString) {
                    oldValue = ((ILocaleString)oldValue).get((Object)lang);
                }
                if (String.valueOf(oldValue).equals(String.valueOf(newValue))) continue;
            }
            newProperties.put(propName, newValue);
        }
        if (WfUtils.isEmptyForMap((Map)newProperties)) {
            return null;
        }
        nodeJSON.put("properties", (Object)newProperties);
        childShapes.clear();
        childShapes.add((Object)nodeJSON);
        contentJSON.put("childShapes", (Object)childShapes);
        return contentJSON.toJSONString();
    }

    private void clearCacheAndReload(CommandContext commandContext, ExecutionEntity processExecution) {
        DynProcessProcessorHelper.updateBpmnModel(processExecution, commandContext);
    }

    static {
        whiteList.add("allowSendTodo");
        whiteList.add("allowTransfer");
        whiteList.add("allowCoordinate");
        whiteList.add("circulateModel.circulateWhenMatch");
        whiteList.add("countersigned");
        whiteList.add("dountersign.signType");
    }
}

