/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.log.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.basedata.role.WorkflowRole;
import kd.bos.workflow.basedata.role.WorkflowRoleEntry;
import kd.bos.workflow.basedata.role.WorkflowRoleResult;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.system.BaseChangeLogsEntity;

public class UpdateWorkflowRoleCmd
implements Command<WorkflowRoleResult> {
    private Log logger = LogFactory.getLog(this.getClass());
    public List<WorkflowRole> roles;
    private static final String FORMATSTRING = "org=%1sfunctiontype=%2suser=%3s";
    private static final String FUNCTIONTYPE = "functiontype";
    private static final String NUMBER = "number";
    private static final String USER_ID = "user_id";
    private static final String ORG_ID = "org_id";
    private static final String POSITION_ID = "approvalPosition_id";
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String USER = "user";
    private static final String ORG = "org";
    private static final String INCLUDADMINSUB = "includadminsub";
    private static final String PARAM = "param";
    private static final String ISADMINORG = "isAdminOrg";

    public UpdateWorkflowRoleCmd(List<WorkflowRole> roles) {
        this.roles = roles;
    }

    @Override
    public WorkflowRoleResult execute(CommandContext commandContext) {
        WorkflowRoleResult result = new WorkflowRoleResult();
        RoleEntityManager roleEntityManager = commandContext.getRoleEntityManager();
        ArrayList<String> numberList = new ArrayList<String>(this.roles.size());
        HashSet<Long> orgSet = new HashSet<Long>(this.roles.size());
        HashSet<Long> userSet = new HashSet<Long>(this.roles.size());
        HashSet<Long> positionSet = new HashSet<Long>(this.roles.size());
        for (WorkflowRole role : this.roles) {
            numberList.add(role.getNumber());
            for (WorkflowRoleEntry entry : role.getRoleEntry()) {
                orgSet.add(entry.getOrg());
                userSet.add(entry.getUser());
                positionSet.add(entry.getApprovalPosition());
            }
        }
        List roleEntity = roleEntityManager.findByQueryFilters(new QFilter[]{new QFilter(NUMBER, "in", numberList)});
        HashMap<String, RoleEntity> roleEntityMap = new HashMap<String, RoleEntity>(this.roles.size());
        for (RoleEntity entity : roleEntity) {
            roleEntityMap.put(entity.getNumber(), entity);
        }
        HashMap<Long, DynamicObject> userMap = new HashMap<Long, DynamicObject>(userSet.size());
        if (!userSet.isEmpty()) {
            DynamicObject[] users;
            for (DynamicObject user : users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userSet)})) {
                userMap.put(user.getLong("id"), user);
            }
        }
        HashMap<Long, DynamicObject> positionMap = new HashMap<Long, DynamicObject>(positionSet.size());
        if (WfUtils.isNotEmptyForCollection(positionSet)) {
            DynamicObject[] positions;
            for (DynamicObject position : positions = BusinessDataServiceHelper.load((String)"bos_position", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", positionSet)})) {
                positionMap.put(position.getLong("id"), position);
            }
        }
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(orgSet.size());
        HashMap<Long, Boolean> adminOrgMap = new HashMap<Long, Boolean>(orgSet.size());
        if (!orgSet.isEmpty()) {
            DynamicObject[] orgs;
            for (DynamicObject org : orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,fisadministrative", (QFilter[])new QFilter[]{new QFilter("id", "in", orgSet)})) {
                orgMap.put(org.getLong("id"), org);
                if (!org.getBoolean("fisadministrative")) continue;
                adminOrgMap.put(org.getLong("id"), Boolean.TRUE);
            }
        }
        StringBuilder errorInfo = new StringBuilder();
        for (WorkflowRole role : this.roles) {
            LocaleString detail = new LocaleString();
            detail = UpdateWorkflowRoleCmd.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString("\u589e\u52a0\u5206\u5f55\uff1a", "UpdateWorkflowRoleCmd_3", "bos-wf-engine"));
            ILocaleString title = WfUtils.getPromptWordLocaleString("\u540c\u6b65\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", "UpdateWorkflowRoleCmd_4", "bos-wf-engine");
            String number = role.getNumber();
            try {
                QFilter qFilter1;
                QFilter qFilter;
                String name = role.getName();
                Long orgUnit = role.getOrgUnit();
                Long manager = role.getManager();
                String description = role.getDescription();
                String roleType = WfUtils.isNotEmpty(role.getRoleType()) ? role.getRoleType() : USER;
                RoleEntity entity = (RoleEntity)roleEntityMap.get(number);
                if (entity != null) {
                    if (!WfUtils.isNullObject(name)) {
                        qFilter = new QFilter("name", "=", (Object)name);
                        qFilter1 = new QFilter(NUMBER, "!=", (Object)number);
                        if (QueryServiceHelper.exists((String)"wf_role", (QFilter[])new QFilter[]{qFilter, qFilter1})) {
                            this.logger.warn(String.format("\u7f16\u7801[%s]\u540c\u6b65\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d;", number));
                            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"UpdateWorkflowRoleCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), number));
                            continue;
                        }
                        entity.setName(name);
                        title = UpdateWorkflowRoleCmd.mulitLangAppendString(title, String.format("%s(%s)", name, number));
                    } else {
                        title = UpdateWorkflowRoleCmd.mulitLangAppendString(title, number);
                    }
                    String entityRoleType = Optional.ofNullable(entity.getRoleType()).orElseGet(() -> USER);
                    if (!roleType.equals(entityRoleType)) {
                        errorInfo.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801[%s]\u540c\u6b65\u5931\u8d25,\u5931\u8d25\u539f\u56e0[\u201c\u89d2\u8272\u7c7b\u578b\u201d\u4e0d\u5141\u8bb8\u4fee\u6539];", (String)"UpdateWorkflowRoleCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), number));
                        continue;
                    }
                    entity.setRoleType(roleType);
                    if (!WfUtils.isNullObject(orgUnit)) {
                        entity.setOrgUnit(orgUnit);
                    }
                    if (!WfUtils.isNullObject(manager)) {
                        entity.setManager(manager);
                    }
                    if (!WfUtils.isNullObject(description)) {
                        entity.setDescription(description);
                    }
                    detail = this.updateRoleEntry(entity, role.getRoleEntry(), (ILocaleString)detail, userMap, orgMap, adminOrgMap, positionMap);
                    roleEntityManager.update(entity);
                } else {
                    entity = (RoleEntity)roleEntityManager.create();
                    qFilter = new QFilter("name", "=", (Object)name);
                    qFilter1 = new QFilter(NUMBER, "!=", (Object)number);
                    if (QueryServiceHelper.exists((String)"wf_role", (QFilter[])new QFilter[]{qFilter, qFilter1})) {
                        this.logger.warn(String.format("\u7f16\u7801[%s]\u540c\u6b65\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d;", number));
                        errorInfo.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"UpdateWorkflowRoleCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), number));
                        continue;
                    }
                    entity.setName(name);
                    title = WfUtils.isNotEmpty(name) ? UpdateWorkflowRoleCmd.mulitLangAppendString(title, String.format("%s(%s)", name, number)) : UpdateWorkflowRoleCmd.mulitLangAppendString(title, number);
                    entity.setNumber(number);
                    entity.setOrgUnit(orgUnit);
                    entity.setManager(manager);
                    entity.setDescription(description);
                    entity.setRoleType(roleType);
                    DynamicObjectCollection collection = entity.getRoleEntry();
                    HashSet<String> set = new HashSet<String>(role.getRoleEntry().size());
                    for (WorkflowRoleEntry entry : role.getRoleEntry()) {
                        Long orgId = entry.getOrg();
                        Long functionId = entry.getFunctiontype();
                        Long basicDataObjId = APPROVALPOSITION.equals(roleType) ? entry.getApprovalPosition() : entry.getUser();
                        Boolean includadminsub = entry.getIncludadminsub();
                        if (set.contains(String.format(FORMATSTRING, orgId, functionId, basicDataObjId)) || !this.isRoleEntryMatchRoleType(roleType, entry.getUser(), entry.getApprovalPosition())) continue;
                        set.add(String.format(FORMATSTRING, orgId, functionId, basicDataObjId));
                        DynamicObject item = new DynamicObject(collection.getDynamicObjectType());
                        item.set(ORG_ID, (Object)orgId);
                        item.set(FUNCTIONTYPE, (Object)functionId);
                        item.set(APPROVALPOSITION.equals(roleType) ? POSITION_ID : USER_ID, (Object)basicDataObjId);
                        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
                        if (adminOrgMap.get(orgId) != null) {
                            item.set(INCLUDADMINSUB, (Object)(StringUtils.isNotBlank((Object)includadminsub) ? includadminsub : Boolean.TRUE));
                            params.put(ISADMINORG, Boolean.TRUE);
                        } else {
                            item.set(INCLUDADMINSUB, (Object)Boolean.FALSE);
                            params.put(ISADMINORG, Boolean.FALSE);
                        }
                        item.set(PARAM, (Object)SerializationUtils.toJsonString(params));
                        collection.add((Object)item);
                        detail = UpdateWorkflowRoleCmd.mulitLangAppend((ILocaleString)detail, this.getAddBasedataFieldDesc(roleType));
                        DynamicObject basedataObj = this.getBasedataObjByRoleType(roleType, basicDataObjId, userMap, positionMap);
                        if (basedataObj != null) {
                            detail = UpdateWorkflowRoleCmd.mulitLangAppend((ILocaleString)detail, basedataObj.getLocaleString("name"));
                            detail = UpdateWorkflowRoleCmd.mulitLangAppendString((ILocaleString)detail, "\u3001");
                        } else {
                            detail = UpdateWorkflowRoleCmd.mulitLangAppendString((ILocaleString)detail, basicDataObjId + "\u3001");
                        }
                        detail = UpdateWorkflowRoleCmd.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString(" \u5ba1\u6279\u7ec4\u7ec7 ", "UpdateWorkflowRoleCmd_6", "bos-wf-engine"));
                        DynamicObject org = (DynamicObject)orgMap.get(orgId);
                        if (org != null) {
                            detail = UpdateWorkflowRoleCmd.mulitLangAppend((ILocaleString)detail, org.getLocaleString("name"));
                            detail = UpdateWorkflowRoleCmd.mulitLangAppendString((ILocaleString)detail, ";");
                            continue;
                        }
                        detail = UpdateWorkflowRoleCmd.mulitLangAppendString((ILocaleString)detail, orgId + ";");
                    }
                    roleEntityManager.insert(entity);
                    roleEntityMap.put(number, entity);
                }
                try {
                    BaseChangeLogsEntity log = (BaseChangeLogsEntity)commandContext.getBaseChangeLogsEntityManager().create();
                    log.setBaseFormId(entity.getId());
                    log.setType("role");
                    log.setOp("api");
                    log.setTitle(WfUtils.subILocaleString(title, 230));
                    log.setDetail((ILocaleString)detail);
                    log.setShowDetail(WfUtils.subILocaleString((ILocaleString)detail, 1000));
                    log.setModifier(RequestContext.get().getUserId());
                    commandContext.getBaseChangeLogsEntityManager().insert(log);
                }
                catch (KDException e) {
                    this.logger.warn(String.format("\u7f16\u7801[%1s]\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25,\u5931\u8d25\u539f\u56e0:%2s;", number, e.toString()));
                }
            }
            catch (KDException e) {
                this.logger.warn(String.format("\u7f16\u7801[%1s]\u540c\u6b65\u5931\u8d25,\u5931\u8d25\u539f\u56e0:%2s;", number, e.toString()));
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1s\u201d\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u201c%2s\u201d\u3002", (String)"UpdateWorkflowRoleCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), number, e.getMessage()));
            }
        }
        if (errorInfo.length() != 0) {
            errorInfo.deleteCharAt(errorInfo.length() - 1);
            errorInfo.append("\u3002");
            result.setResult(Boolean.FALSE.booleanValue());
            result.setDesc(errorInfo.toString());
        } else {
            result.setResult(Boolean.TRUE.booleanValue());
            result.setDesc(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"UpdateWorkflowRoleCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return result;
    }

    private ILocaleString updateRoleEntry(RoleEntity entity, List<WorkflowRoleEntry> list, ILocaleString detail, Map<Long, DynamicObject> userMap, Map<Long, DynamicObject> orgMap, Map<Long, Boolean> adminOrgMap, Map<Long, DynamicObject> positionMap) {
        DynamicObjectCollection collection = entity.getRoleEntry();
        HashSet<String> set = new HashSet<String>(collection.size());
        String roleType = entity.getRoleType();
        for (DynamicObject roleentry : collection) {
            Long basicDataObjId = APPROVALPOSITION.equals(roleType) ? roleentry.getLong(POSITION_ID) : roleentry.getLong(USER_ID);
            set.add(String.format(FORMATSTRING, roleentry.getLong(ORG_ID), roleentry.getLong(FUNCTIONTYPE), basicDataObjId));
        }
        for (WorkflowRoleEntry entry : list) {
            Long orgId = entry.getOrg();
            Long functionId = entry.getFunctiontype();
            Long basicDataObjId = APPROVALPOSITION.equals(roleType) ? entry.getApprovalPosition() : entry.getUser();
            Boolean includadminsub = entry.getIncludadminsub();
            if (set.contains(String.format(FORMATSTRING, orgId, functionId, basicDataObjId)) || !this.isRoleEntryMatchRoleType(roleType, entry.getUser(), entry.getApprovalPosition())) continue;
            set.add(String.format(FORMATSTRING, orgId, functionId, basicDataObjId));
            DynamicObject item = new DynamicObject(collection.getDynamicObjectType());
            item.set(ORG_ID, (Object)orgId);
            item.set(FUNCTIONTYPE, (Object)functionId);
            item.set(APPROVALPOSITION.equals(roleType) ? POSITION_ID : USER_ID, (Object)basicDataObjId);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
            if (adminOrgMap.get(orgId) != null) {
                item.set(INCLUDADMINSUB, (Object)(StringUtils.isNotBlank((Object)includadminsub) ? includadminsub : Boolean.TRUE));
                params.put(ISADMINORG, Boolean.TRUE);
            } else {
                item.set(INCLUDADMINSUB, (Object)Boolean.FALSE);
                params.put(ISADMINORG, Boolean.FALSE);
            }
            item.set(PARAM, (Object)SerializationUtils.toJsonString(params));
            collection.add((Object)item);
            detail = UpdateWorkflowRoleCmd.mulitLangAppend(detail, this.getAddBasedataFieldDesc(roleType));
            DynamicObject basicDataObj = this.getBasedataObjByRoleType(roleType, basicDataObjId, userMap, positionMap);
            if (basicDataObj != null) {
                detail = UpdateWorkflowRoleCmd.mulitLangAppend(detail, basicDataObj.getLocaleString("name"));
                detail = UpdateWorkflowRoleCmd.mulitLangAppendString(detail, "\u3001");
            } else {
                detail = UpdateWorkflowRoleCmd.mulitLangAppendString(detail, basicDataObjId + "\u3001");
            }
            detail = UpdateWorkflowRoleCmd.mulitLangAppend(detail, WfUtils.getPromptWordLocaleString(" \u5ba1\u6279\u7ec4\u7ec7 ", "UpdateWorkflowRoleCmd_6", "bos-wf-engine"));
            DynamicObject org = orgMap.get(orgId);
            if (org != null) {
                detail = UpdateWorkflowRoleCmd.mulitLangAppend(detail, org.getLocaleString("name"));
                detail = UpdateWorkflowRoleCmd.mulitLangAppendString(detail, ";");
                continue;
            }
            detail = UpdateWorkflowRoleCmd.mulitLangAppendString(detail, orgId + ";");
        }
        return detail;
    }

    private static ILocaleString mulitLangAppend(ILocaleString lString1, ILocaleString lString2) {
        return WfMultiLangUtils.jointILocaleString(lString1, lString2, "");
    }

    private static ILocaleString mulitLangAppendString(ILocaleString lString, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)lString.getItem(l)) ? "" : (String)lString.getItem(l);
            lString.setItem(l, (Object)(itemStr + string));
        }
        return lString;
    }

    private ILocaleString getAddBasedataFieldDesc(String roleType) {
        return APPROVALPOSITION.equals(roleType) ? ResManager.getLocaleString((String)" \u5ba1\u6279\u5c97\u4f4d ", (String)"UpdateWorkflowRoleCmd_7", (String)"bos-wf-engine") : ResManager.getLocaleString((String)" \u5ba1\u6279\u4eba\u5458 ", (String)"UpdateWorkflowRoleCmd_5", (String)"bos-wf-engine");
    }

    private boolean isRoleEntryMatchRoleType(String roleType, Long userId, Long positionId) {
        return APPROVALPOSITION.equals(roleType) && WfUtils.isNotEmpty(positionId) || USER.equals(roleType) && WfUtils.isNotEmpty(userId);
    }

    private DynamicObject getBasedataObjByRoleType(String roleType, Long basicDataObjId, Map<Long, DynamicObject> userMap, Map<Long, DynamicObject> positionMap) {
        if (APPROVALPOSITION.equals(roleType)) {
            return positionMap.get(basicDataObjId);
        }
        return userMap.get(basicDataObjId);
    }
}

