/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.rule.expression.property.ExpressionPropCache;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.validation.ExecBaseElementValidator;
import kd.bos.workflow.validation.ExecDataValidator;
import kd.bos.workflow.validation.ExecMainProcessValidator;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.ValidatorRegistCenter;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class ValidateProcessByBpmnModelCmd
implements Command<List<ValidationError>> {
    private BpmnModel bpmnModel;
    private ConditionalRuleEntity condRule;

    public ValidateProcessByBpmnModelCmd(BpmnModel bpmnModel, ConditionalRuleEntity condRule) {
        this.bpmnModel = bpmnModel;
        this.condRule = condRule;
    }

    @Override
    public List<ValidationError> execute(CommandContext commandContext) {
        ArrayList<ValidationError> ret = new ArrayList();
        try {
            commandContext.addAttribute("propsCache", new ExpressionPropCache());
            ret = this.executeValidate(commandContext);
        }
        finally {
            commandContext.removeAttribute("propsCache");
        }
        return ret;
    }

    private List<ValidationError> executeValidate(CommandContext commandContext) {
        ExecMainProcessValidator processValidator;
        List<ValidationError> processValidatorErrors;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        ArrayList<ValidationData> validationDatas = new ArrayList<ValidationData>();
        Process mainProcess = this.bpmnModel.getMainProcess();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("title", mainProcess.getName());
        keyMap.put("processType", mainProcess.getProcessType());
        keyMap.put("secondTitle", "");
        keyMap.put("defaultDescription", mainProcess.getNumber());
        keyMap.put("entityNumber", mainProcess.getEntraBill());
        keyMap.put("bpmnModel", this.bpmnModel);
        try {
            mainProcess.getForkJoinModels();
            mainProcess.getNodeAffectJoinNodeComeFlow();
        }
        catch (Exception e) {
            String info = ResManager.loadKDString((String)"\u6d41\u7a0b\u5206\u652f\u6c47\u805a\u6a21\u578b\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u5206\u652f\u6c47\u805a\u76f8\u5173\u8282\u70b9\u8fde\u7ebf\u3002", (String)"ValidateProcessByBpmnModelCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            tMap.putAll(keyMap);
            tMap.put("info", info);
            tMap.put("infoType", "error");
            validationErrors.add(ValidatorUtil.getValidationError(tMap));
        }
        keyMap.put("procMacro", ExpressionPropUtils.getProcMacroProp(mainProcess, ConditionalRuleType.skip.toString(), null));
        keyMap.put("billEntityMeta", (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)mainProcess.getEntraBill(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity));
        if (null != this.condRule) {
            List<ConditionalEntity> conditionRules = this.condRule.getEntryentity();
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            tMap.putAll(keyMap);
            tMap.put("objName", ResManager.loadKDString((String)"\u65b9\u6848\u8bbe\u7f6e", (String)"ValidateProcessByBpmnModelCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            tMap.put("objType", "");
            tMap.put("info", ResManager.loadKDString((String)"\u65b9\u6848\u9002\u7528\u6761\u4ef6 ", (String)"ValidateProcessByBpmnModelCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            tMap.put("ruleType", this.condRule.getType());
            tMap.put("infoType", "error");
            ValidatorUtil.collectValidationDatasFromConditionRules(mainProcess, conditionRules, validationDatas, tMap, null);
        }
        if (!(processValidatorErrors = (processValidator = (ExecMainProcessValidator)ValidatorRegistCenter.getValidatorByType("process")).validate(mainProcess, validationDatas, keyMap)).isEmpty()) {
            validationErrors.addAll(processValidatorErrors);
        }
        List<FlowElement> flowElementList = this.bpmnModel.getMainProcess().getFlowElementList();
        for (FlowElement flowElement : flowElementList) {
            List<ValidationError> flowElementValidatorErrors;
            ExecBaseElementValidator flowElementValidator = (ExecBaseElementValidator)ValidatorRegistCenter.getValidatorByType(flowElement.getType());
            if (flowElementValidator == null || (flowElementValidatorErrors = flowElementValidator.validate(mainProcess, flowElement, validationDatas, keyMap)).isEmpty()) continue;
            validationErrors.addAll(flowElementValidatorErrors);
        }
        ValidationDataCollator validationDataCollator = ValidatorUtil.collatValidationDatas(validationDatas);
        ExecDataValidator dataValidator = (ExecDataValidator)ValidatorRegistCenter.getValidatorByType("data");
        List<ValidationError> dataValidatorErrors = dataValidator.validate(validationDataCollator);
        if (!dataValidatorErrors.isEmpty()) {
            validationErrors.addAll(dataValidatorErrors);
        }
        return validationErrors;
    }
}

