/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.AbstractWaitEventReceivedCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.DelayBroadcastJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;

public class WaitEventReceivedCmd
extends AbstractWaitEventReceivedCmd {
    public WaitEventReceivedCmd(Long subscriptionId, Map<String, Object> payload, boolean async) {
        super(subscriptionId, payload, async);
    }

    public WaitEventReceivedCmd(String eventNumber, Long executionId, Map<String, Object> payload, boolean async) {
        super(eventNumber, executionId, payload, async);
    }

    @Override
    protected void processEventAsync(CommandContext commandContext) {
        String businessKey = (String)this.payload.get("businessKey");
        this.log.debug("businessKey: " + businessKey);
        List<EventSubscriptionEntity> eventSubscriptionEntities = super.getEventSubscriptionEntities(commandContext);
        if ((eventSubscriptionEntities == null || eventSubscriptionEntities.isEmpty()) && WfUtils.isNotEmpty(this.executionId)) {
            this.log.debug(String.format("no event subscription can be found. %s %s", this.eventNumber, this.executionId));
        } else {
            this.log.debug("begin scheduleEvent...");
            this.scheduleMatchedEventsAsync(commandContext, eventSubscriptionEntities);
        }
        DelayBroadcastJobHandler handler = new DelayBroadcastJobHandler();
        handler.insertDelayBroadcastJob(commandContext, this.executionId, this.eventNumber, this.payload);
    }

    @Override
    protected String getWaitEvent(FlowElement element) {
        TimingModel timingModel = this.getTimingModel(element);
        if (timingModel != null) {
            return timingModel.getEvent();
        }
        return null;
    }

    @Override
    protected ConditionalRuleEntity getWaitCondition(FlowElement element) {
        TimingModel timingModel = this.getTimingModel(element);
        if (timingModel != null) {
            return timingModel.getCondition();
        }
        return null;
    }

    private TimingModel getTimingModel(FlowElement element) {
        if (element instanceof WaitTask) {
            WaitTask waitTask = (WaitTask)element;
            return waitTask.getTimingModel();
        }
        return null;
    }

    @Override
    protected String getWaitEventSubscriptionType() {
        return "waitevent";
    }
}

