/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.deploy;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessDefinitionCmd;
import kd.bos.workflow.engine.impl.cmd.SuspendProcessDefinitionCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.repository.DeploymentBuilderImpl;
import kd.bos.workflow.engine.repository.Deployment;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        return this.executeDeploy(commandContext);
    }

    protected Deployment executeDeploy(CommandContext commandContext) {
        DeploymentEntity existingDeployment;
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled() && (existingDeployment = commandContext.getDeploymentEntityManager().findLatestDeploymentByName(deployment.getName())) != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
            return existingDeployment;
        }
        deployment.setNew(true);
        commandContext.getDeploymentEntityManager().insert(deployment);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, deployment));
        }
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isBpmn20XsdValidationEnabled", this.deploymentBuilder.isBpmn20XsdValidationEnabled());
        deploymentSettings.put("isProcessValidationEnabled", this.deploymentBuilder.isProcessValidationEnabled());
        deploymentSettings.put("isProcessActivateEnabled", this.deploymentBuilder.isProcessDefinitionsActivated());
        if (this.deploymentBuilder.getDeploymentProperties() != null) {
            deploymentSettings.putAll(this.deploymentBuilder.getDeploymentProperties());
        }
        commandContext.getProcessEngineConfiguration().getDeploymentManager().deploy(deployment, deploymentSettings);
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            this.scheduleProcessDefinitionActivation(commandContext, deployment);
        }
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, deployment));
        }
        return deployment;
    }

    protected boolean deploymentsDiffer(DeploymentEntity deployment, DeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (Map.Entry<String, ResourceEntity> entry : resources.entrySet()) {
            byte[] savedBytes;
            ResourceEntity resource;
            byte[] bytes;
            String resourceName = entry.getKey();
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = entry.getValue()).getData().getBytes(StandardCharsets.UTF_8), savedBytes = savedResource.getData().getBytes(StandardCharsets.UTF_8))) continue;
            return true;
        }
        return false;
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
            SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null);
            suspendProcessDefinitionCmd.execute(commandContext);
            ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, this.deploymentBuilder.getProcessDefinitionsActivationDate());
            activateProcessDefinitionCmd.execute(commandContext);
        }
    }
}

