/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.entity;

import java.io.Serializable;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class CountEntityCmd
implements Command<Long>,
Serializable {
    private QFilter[] filters;
    private boolean distinct;
    private EntityQueryBuilder qb;
    private String entityNumber;
    private String field = "id";
    private static final long serialVersionUID = 1480016140239461724L;

    public CountEntityCmd(String entityNumber, QFilter[] filters) {
        this.filters = filters;
        this.entityNumber = entityNumber;
    }

    public CountEntityCmd(String entityNumber, QFilter[] filters, boolean distinct) {
        this.filters = filters;
        this.entityNumber = entityNumber;
        this.distinct = distinct;
    }

    public CountEntityCmd(String entityNumber, QFilter[] filters, boolean distinct, String field) {
        this.filters = filters;
        this.entityNumber = entityNumber;
        this.distinct = distinct;
        this.field = field;
    }

    public CountEntityCmd(String entityNumber, EntityQueryBuilder builder) {
        this.entityNumber = entityNumber;
        this.qb = builder;
    }

    public CountEntityCmd(String entityNumber, EntityQueryBuilder builder, boolean distinct) {
        this.entityNumber = entityNumber;
        this.qb = builder;
        this.distinct = distinct;
    }

    public CountEntityCmd(String entityNumber, EntityQueryBuilder builder, boolean distinct, String field) {
        this.entityNumber = entityNumber;
        this.qb = builder;
        this.distinct = distinct;
        this.field = field;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (this.qb != null) {
            return commandContext.getEntityManagerByEntityNumber(this.entityNumber).countByFilter(this.field, this.qb.getFilters(), this.distinct);
        }
        return commandContext.getEntityManagerByEntityNumber(this.entityNumber).countByFilter(this.field, this.filters, this.distinct);
    }
}

