/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class FindEntityCmd<T extends Entity>
implements Command<List<T>>,
Serializable {
    private static final long serialVersionUID = 7361441327287393816L;
    private QFilter[] filters;
    private String fields;
    private String sort;
    private EntityQueryBuilder<T> eb;
    private String entityNumber;

    public FindEntityCmd(EntityQueryBuilder<T> eb, String entityNumber) {
        this.eb = eb;
        this.entityNumber = entityNumber;
    }

    public FindEntityCmd(QFilter[] filters, String entityNumber) {
        this.filters = filters;
        this.entityNumber = entityNumber;
    }

    public FindEntityCmd(QFilter[] qFilters, String fields, String sort, String entityNumber) {
        this.filters = qFilters;
        this.fields = fields;
        this.sort = sort;
        this.entityNumber = entityNumber;
    }

    @Override
    public List<T> execute(CommandContext commandContext) {
        List<Object> list = new ArrayList();
        if (this.eb != null) {
            list = commandContext.getEntityManagerByEntityNumber(this.entityNumber).findByQueryBuilder(this.eb);
        } else if (this.filters != null) {
            list = commandContext.getEntityManagerByEntityNumber(this.entityNumber).findByQueryFilters(this.filters, this.fields, this.sort);
        }
        return list;
    }
}

