/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.entity;

import java.io.Serializable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class GetSingleEntityCmd<T extends Entity>
implements Command<T>,
Serializable {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long id;
    private String entityNumber;
    private String fields;
    private static final long serialVersionUID = 3515788130973260082L;

    public GetSingleEntityCmd(Long id, String entityNumber) {
        this.id = id;
        this.entityNumber = entityNumber;
    }

    public GetSingleEntityCmd(Long id, String entityNumber, String fields) {
        this.id = id;
        this.entityNumber = entityNumber;
        this.fields = fields;
    }

    @Override
    public T execute(CommandContext commandContext) {
        try {
            return commandContext.getEntityManagerByEntityNumber(this.entityNumber).findById(this.id, this.fields);
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }
}

