/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.runtime.Execution;

public class AbandonRootProcessInstance
implements Command<Void> {
    public static final Log log = LogFactory.getLog(AbandonRootProcessInstance.class);
    public final String businessKey;

    public AbandonRootProcessInstance(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter qFilter = new QFilter("processtype", "in", (Object)Lists.newArrayList((Object[])new String[]{ModelType.AuditFlow.name(), ModelType.BizFlow.name()}));
        QFilter qFilter2 = new QFilter("businesskey", "=", (Object)this.businessKey);
        QFilter qFilter3 = new QFilter("parentid", "=", (Object)0);
        List instances = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{qFilter, qFilter2, qFilter3});
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        Set collect = instances.stream().filter(item -> item.getRootProcessInstanceId() != null && item.getRootProcessInstanceId() != 0L).map(Execution::getRootProcessInstanceId).collect(Collectors.toSet());
        for (Long root : collect) {
            try {
                new AbandonProcessCmd(root).execute(commandContext);
            }
            catch (Throwable err) {
                log.warn(err);
            }
        }
        return null;
    }
}

