/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public abstract class AbstractBatchQueryCmd<T>
implements Command<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected int count = 100;
    protected String routeKey;

    @Override
    public T execute(CommandContext commandContext) {
        T ret = this.createRet();
        ArrayList<String> billIds = new ArrayList<String>(this.getTotal());
        int billCount = billIds.size();
        int j = billCount % this.count != 0 ? billCount / this.count + 1 : billCount / this.count;
        try (DataSet unionDs = null;){
            for (int x = 0; x < j; ++x) {
                int end = (x + 1) * this.count > billCount ? billCount : (x + 1) * this.count;
                List<String> subList = billIds.subList(x * this.count, end);
                if (subList == null || subList.isEmpty()) continue;
                String sql = this.createSQL(subList);
                Object[] params = this.createParameter(subList);
                DBRoute route = WfUtils.isEmpty(this.routeKey) ? DBRoute.workflow : DBRoute.of((String)this.routeKey);
                DataSet ds = DB.queryDataSet((String)("wf.engine." + this.getClass().getSimpleName()), (DBRoute)route, (String)sql, (Object[])params);
                unionDs = unionDs == null ? ds : unionDs.union(ds);
            }
            if (unionDs != null) {
                for (Row r : unionDs) {
                    this.handleResult(ret, r);
                }
                this.afterHandlerRet(ret);
            }
        }
        return ret;
    }

    protected abstract void handleResult(T var1, Row var2);

    protected abstract Object[] createParameter(List<String> var1);

    protected abstract String createSQL(List<String> var1);

    protected abstract Collection<String> getTotal();

    protected abstract T createRet();

    protected void afterHandlerRet(T ret) {
    }
}

