/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AddJointAuditParticipantsCmd
implements Command<Void> {
    private String businesskey;
    private String nodeId;
    private List<Long> participants;
    private Map<String, String> variables;

    public AddJointAuditParticipantsCmd(String businesskey, String nodeId, List<Long> participants, Map<String, String> variables) {
        this.businesskey = businesskey;
        this.nodeId = nodeId;
        this.participants = participants;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.businesskey) || WfUtils.isEmpty(this.nodeId) || this.participants == null || this.participants.isEmpty()) {
            throw new KDException("invalid parameters.");
        }
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTaskIdByBusinessKeyAndNodeId(this.businesskey, this.nodeId);
        if (tasks == null || tasks.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u5fc5\u987b\u662f\u5f53\u524d\u8282\u70b9\u3002", (String)"AddJointAuditParticipantsCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        TaskEntity task = tasks.get(0);
        if (!BpmnModelUtil.instanceofYunzhijiaTask(task.getCategory())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u5fc5\u987b\u662f\u4f1a\u5ba1\u8282\u70b9\u3002", (String)"AddJointAuditParticipantsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        FlowElement elem = ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), this.nodeId);
        if (elem instanceof YunzhijiaTask) {
            RunTimeLog.get().init(SceneType.YUNZHIJIEPARTICIPANTADDBYJOGGLE, LogClassType.PARTICIPANT_LOG_BLOCK);
            Object behavior = ((YunzhijiaTask)elem).getBehavior();
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.ADDPARTICIPANT_1.getDesc(), task.getName()));
            if (behavior instanceof ParallelMultiInstanceBehavior) {
                this.addJointAuditParticipantsForParallel(commandContext, task, behavior);
            } else if (behavior instanceof SequentialMultiInstanceBehavior) {
                this.addJointAuditParticipantsForSequential(commandContext, task, behavior);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u4e0d\u652f\u6301\u6216\u8005\u4e0d\u662f\u4eba\u5de5\u5904\u7406\u7c7b\u8282\u70b9\uff01", (String)"AddJointAuditParticipantsCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        RunTimeLog.get().endBlock();
        RunTimeLog.get().end(task);
        return null;
    }

    private void addJointAuditParticipantsForSequential(CommandContext commandContext, TaskEntity task, Object behavior) {
        if (task.getExecution() != null) {
            String ids = (String)task.getVariableLocal("teamMembers");
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.addAll(WfUtils.stringToCollection(ids, ","));
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.ADDPARTICIPANT_2.getDesc(), RunTimeLog.get().collectAndSubstitution((List)WfUtils.stringToCollection(ids, ","), "user")));
            String appointUserId = this.variables != null ? this.variables.get("appointUserId") : null;
            long targeAppointUserId = WfUtils.isEmpty(appointUserId) ? 0L : Long.parseLong(appointUserId);
            int loopCounter = 0;
            if (task.getExecution().getVariable("loopCounter") != null) {
                loopCounter = (Integer)task.getExecution().getVariable("loopCounter");
            }
            if (WfUtils.isNotEmpty(appointUserId)) {
                if (!userIds.contains(targeAppointUserId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u4eba\u5458\u4e0d\u662f\u4f1a\u5ba1\u8282\u70b9\u53c2\u4e0e\u4eba\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"AddJointAuditParticipantsCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                int userIndex = userIds.indexOf(targeAppointUserId);
                if (userIndex < loopCounter) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u5ba1\u6279\u7684\u4eba\u5458\u4e0d\u80fd\u4f5c\u4e3a\u53c2\u7167\u4eba\u5458\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"AddJointAuditParticipantsCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.ADDPARTICIPANT_4.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            Iterator<Long> iter = this.participants.iterator();
            while (iter.hasNext()) {
                if (!userIds.contains(iter.next())) continue;
                iter.remove();
            }
            if (this.participants != null && !this.participants.isEmpty()) {
                this.participants = WfUtils.filterEnableUsers(this.participants);
            }
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.ADDPARTICIPANT_5.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            if (this.participants != null && !this.participants.isEmpty()) {
                if (WfUtils.isNotEmpty(appointUserId)) {
                    ArrayList<Long> transitionUserIds = new ArrayList<Long>(userIds.size() + this.participants.size());
                    for (Long userId : userIds) {
                        if (userId.equals(targeAppointUserId)) {
                            transitionUserIds.add(userId);
                            transitionUserIds.addAll(this.participants);
                            continue;
                        }
                        transitionUserIds.add(userId);
                    }
                    userIds.clear();
                    userIds.addAll(transitionUserIds);
                } else {
                    userIds.addAll(this.participants);
                }
                ILocaleString participantName = commandContext.getProcessEngineConfiguration().getTaskHelper().getParticipantName(userIds);
                ILocaleString participantNameFormater = ParticipantHelper.getUserNameFormatValue(task, userIds);
                task.setVariableLocal("teamMembers", WfUtils.listToString(userIds, ","));
                if (WfUtils.isNotEmpty(participantName)) {
                    task.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)participantName));
                }
                if (WfUtils.isNotEmpty(participantNameFormater)) {
                    task.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
                }
                ((SequentialMultiInstanceBehavior)behavior).addInstances(task.getExecution(), this.participants);
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.ADDPARTICIPANT_6.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
        }
    }

    private void addJointAuditParticipantsForParallel(CommandContext commandContext, TaskEntity task, Object behavior) {
        if (task.getExecution() != null) {
            List<HistoricTaskInstanceEntity> approvedTasks;
            String ids = (String)task.getVariableLocal("teamMembers");
            HashSet<Long> userIds = new HashSet<Long>();
            userIds.addAll(WfUtils.stringToCollection(ids, ","));
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.ADDPARTICIPANT_2.getDesc(), RunTimeLog.get().collectAndSubstitution((List)WfUtils.stringToCollection(ids, ","), "user")));
            ArrayList<HistoricTaskInstanceEntity> approvedExcecution = new ArrayList<HistoricTaskInstanceEntity>(userIds.size());
            boolean recovery = this.variables != null && this.variables.get("Revovery") != null;
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.ADDPARTICIPANT_4.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            ArrayList<Long> notApprovalUser = new ArrayList<Long>();
            if (recovery && (approvedTasks = commandContext.getHistoricTaskInstanceEntityManager().findApprovedTaskByParentTaskId(task.getProcessInstanceId(), task.getId())) != null && !approvedTasks.isEmpty()) {
                for (HistoricTaskInstanceEntity entity : approvedTasks) {
                    if (!this.participants.contains(entity.getAssigneeId())) continue;
                    notApprovalUser.add(entity.getAssigneeId());
                    approvedExcecution.add(entity);
                    this.participants.remove(entity.getAssigneeId());
                }
            }
            if (notApprovalUser.size() > 0) {
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.ADDPARTICIPANT_7.getDesc(), RunTimeLog.get().collectAndSubstitution(notApprovalUser, "user")));
            }
            Iterator<Long> iter = this.participants.iterator();
            while (iter.hasNext()) {
                if (!userIds.contains(iter.next())) continue;
                iter.remove();
            }
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.ADDPARTICIPANT_5.getDesc(), this.participants == null || this.participants.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            if (!this.participants.isEmpty()) {
                this.participants = WfUtils.filterEnableUsers(this.participants);
                if (!this.participants.isEmpty()) {
                    ILocaleString participantNameFormater;
                    userIds.addAll(this.participants);
                    task.setVariableLocal("teamMembers", WfUtils.listToString(userIds, ","));
                    ArrayList<Long> t = new ArrayList<Long>(userIds);
                    ILocaleString participantName = commandContext.getProcessEngineConfiguration().getTaskHelper().getParticipantName(t);
                    if (WfUtils.isNotEmpty(participantName)) {
                        task.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)participantName));
                    }
                    if (WfUtils.isNotEmpty(participantNameFormater = ParticipantHelper.getUserNameFormatValue(task, userIds))) {
                        task.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
                    }
                    ((ParallelMultiInstanceBehavior)behavior).addInstances(task.getExecution(), this.participants);
                }
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.ADDPARTICIPANT_6.getDesc(), this.participants == null || this.participants.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            if (recovery && !approvedExcecution.isEmpty()) {
                ((ParallelMultiInstanceBehavior)behavior).recoverInstances(approvedExcecution, this.variables);
            }
        }
    }
}

