/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;

@Deprecated
public class BatchSubmitBillCmd
implements Command<Void> {
    private static final String BILLNO = "billno";
    private static final String PERFORMANCE_BILL_ENTITY_NUMBER = "wf_performance_bill";
    private static final String AUTO_IMPORT_BILLNO = "auto_import_wf_performance_bill";
    private static final String BILLSTATUS = "billstatus";
    private int amount;
    private String procdefid;
    private Log log = LogFactory.getLog(this.getClass());
    private Random random = new SecureRandom();

    public BatchSubmitBillCmd(int amount, String procdefid) {
        this.amount = amount;
        this.procdefid = procdefid;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if ("-1".equalsIgnoreCase(this.procdefid)) {
            this.batchSubmitMsg(this.amount);
        } else {
            this.batchSubmitBill(this.amount, this.procdefid);
        }
        return null;
    }

    private void batchSubmitMsg(int amount) {
        String currentDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        Integer suffix = this.random.nextInt(100000);
        String msgContent = String.format("%s-%s-%s", AUTO_IMPORT_BILLNO, currentDate, suffix.toString());
        for (int i = 0; i < amount; ++i) {
            MessageInfo msg = new MessageInfo();
            ArrayList<Long> ap = new ArrayList<Long>();
            ap.add(Long.valueOf(RequestContext.get().getUserId()));
            msg.setUserIds(ap);
            LocaleString cc = new LocaleString();
            cc.setLocaleValue_zh_CN(msgContent);
            msg.setMessageContent((ILocaleString)cc);
            msg.setTitle(msgContent);
            msg.setType("message");
            MessageCenterServiceHelper.sendMessage((MessageInfo)msg);
        }
    }

    public DynamicObject getOneBill(int index) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)PERFORMANCE_BILL_ENTITY_NUMBER);
        DynamicObject billObj = new DynamicObject((DynamicObjectType)entityType);
        String billno = null;
        if (billObj.getDynamicObjectType().getProperty(BILLNO) != null) {
            String currentDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            Integer suffix = this.random.nextInt(100000);
            billno = String.format("%s-%s-%s", AUTO_IMPORT_BILLNO, currentDate, suffix.toString());
            billObj.set(BILLNO, (Object)billno);
        }
        if (billObj.getDynamicObjectType().getProperty(BILLSTATUS) != null) {
            billObj.set(BILLSTATUS, (Object)"A");
        }
        billObj.set("date", (Object)new Date());
        billObj.set("reason", (Object)("test" + index));
        billObj.set("id", (Object)ORM.create().genLongId(PERFORMANCE_BILL_ENTITY_NUMBER));
        return billObj;
    }

    private void batchSubmitBill(int amount, String procdefid) {
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(amount);
        for (int i = 0; i < amount; ++i) {
            DynamicObject bill = this.getOneBill(i);
            dyns.add(bill);
            this.log.debug(String.format("genenateBill\uff1a%s", bill.get(BILLNO)));
        }
        if (dyns != null && !dyns.isEmpty()) {
            OperationResult ret;
            OperateOption options = OperateOption.create();
            options.setVariableValue("ishasright", String.valueOf(true));
            options.setVariableValue("isStrict", "false");
            if (procdefid != null && WfUtils.isNotEmpty(procdefid)) {
                options.setVariableValue("procdefid", procdefid);
            }
            if ((ret = OperationServiceHelper.executeOperate((String)"submit", (String)PERFORMANCE_BILL_ENTITY_NUMBER, (DynamicObject[])dyns.toArray(new DynamicObject[dyns.size()]), (OperateOption)options)) != null && ret.isSuccess()) {
                this.log.debug(String.format("batch submit bill ok [%s]", ret.getSuccessPkIds().size()));
            } else if (ret != null) {
                List errs = ret.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                sb.append(ret.getMessage());
                if (errs != null && !errs.isEmpty()) {
                    for (IOperateInfo info : errs) {
                        sb.append(info.getTitle()).append(":").append(info.getMessage());
                    }
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u5931\u8d25\u3002\u539f\u56e0\uff1a%s", (String)"BatchSumbitBillCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), sb.toString()));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u5931\u8d25\u3002\u539f\u56e0\uff1a%s", (String)"BatchSumbitBillCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), "the num is zero."));
        }
    }

    public static class BillInfo {
        private String businessKey;
        private String billNo;

        public BillInfo(String businessKey, String billNo) {
            this.businessKey = businessKey;
            this.billNo = billNo;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }
    }
}

