/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.io.Serializable;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.delegate.SubProcessActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFEngineException;

public class CompleteCallActivityCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private static final String ERRORFORMATSTR = "%s %s";
    private static final String ERRORMSG = "Error while completing super process of execution";
    private Long executionId;
    private Map<String, Object> variablesForParent;

    public CompleteCallActivityCmd(Long executionId, Map<String, Object> variablesForParent) {
        this.executionId = executionId;
        this.variablesForParent = variablesForParent;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity superExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            FlowNode superExecutionElement = (FlowNode)superExecution.getCurrentFlowElement();
            if (superExecutionElement instanceof BillTask) {
                subProcessActivityBehavior = (SubProcessActivityBehavior)((BillTask)superExecutionElement).getBillTaskCallActivity().getBehavior();
            } else if (superExecutionElement instanceof CallActivity) {
                subProcessActivityBehavior = (SubProcessActivityBehavior)superExecutionElement.getBehavior();
            }
            if (subProcessActivityBehavior instanceof ParallelMultiInstanceBehavior) {
                subProcessActivityBehavior = (SubProcessActivityBehavior)((Object)((ParallelMultiInstanceBehavior)subProcessActivityBehavior).getInnerActivityBehavior());
            }
            try {
                if (subProcessActivityBehavior != null) {
                    superExecution.setVariables(this.variablesForParent);
                    subProcessActivityBehavior.completed(superExecution);
                }
            }
            catch (RuntimeException e) {
                this.logger.error(String.format(ERRORFORMATSTR, ERRORMSG, superExecution), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                String errMsg = String.format(ERRORFORMATSTR, ERRORMSG, superExecution);
                this.logger.error(errMsg, (Throwable)e);
                throw new WFEngineException(errMsg, e);
            }
        }
        return null;
    }
}

