/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.manager.RuntimeParseLogManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeleteAllRuntimeDatasByProcessInstanceIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 6176482478301997488L;
    private static final String TERMINATE = "terminate";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String EVENTLOGENTRYESENTITYMANAGER = "kd.bos.workflow.engine.impl.log.manager.EventLogEntryEsEntityManager";
    protected Long processInstanceId;
    private Log log = LogFactory.getLog(this.getClass());

    public DeleteAllRuntimeDatasByProcessInstanceIdCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new WFIllegalArgumentException("processInstanceId is null");
        }
        this.deleteProcessInstanceDatas(commandContext);
        QFilter[] filters = new QFilter[]{new QFilter("superProcessInstanceId", "=", (Object)this.processInstanceId)};
        List children = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters);
        if (children != null && !children.isEmpty()) {
            for (HistoricProcessInstanceEntity child : children) {
                new DeleteAllRuntimeDatasByProcessInstanceIdCmd(child.getId()).execute(commandContext);
            }
        }
        return null;
    }

    private void deleteProcessInstanceDatas(CommandContext commandContext) {
        HistoricProcessInstanceEntity entity;
        this.log.debug("DeleteAllRuntimeDatasByProcessInstanceIdCmd processInstanceId : " + this.processInstanceId);
        QFilter[] qFilters = this.getFilters(PROCESSINSTANCEID);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (execution != null) {
            commandContext.getExecutionEntityManager().deleteProcessInstance(this.processInstanceId, null, false);
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(process, execution, "end");
        }
        if ((entity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId)) != null) {
            commandContext.getHistoricProcessInstanceEntityManager().delete(entity);
        }
        commandContext.getTaskEntityManager().deleteTasksByProcessInstanceId(this.processInstanceId, null, true);
        commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByProcessInstanceId(this.processInstanceId);
        commandContext.getTrdCommentEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getDynamicResourceEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getPreComputorEntityManager().deleteInstanceByProcInstId(this.processInstanceId);
        commandContext.getFeedbackEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(this.processInstanceId);
        commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(this.processInstanceId);
        commandContext.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByProcInstance(this.processInstanceId);
        commandContext.getHistoricDynamicResourceEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(this.processInstanceId);
        commandContext.getCommentEntityManager().deleteCommentsByProcessInstanceId(this.processInstanceId);
        commandContext.getHistoricFeedbackEntityManager().deleteByFilters(qFilters);
        commandContext.getHistoricAttachmentEntityManager().deleteByFilters(qFilters);
        commandContext.getAuditPointInstanceEntityManager().deleteByFilters(qFilters);
        commandContext.getHistoricProcCompactEntityManager().deleteHistoricActInstWideEntityByProcInstId(this.processInstanceId);
        commandContext.getHiUserActInstEntityManager().deleteByProinstId(this.processInstanceId);
        commandContext.getRuleTaskRelationEntityManager().deleteByFilters(this.getFilters(PROCESSINSTANCEID));
        commandContext.getConditionParseLogManager().deleteByFilters(this.getFilters(PROCESSINSTANCEID));
        commandContext.getCirculateRelationEntityManager().deleteByFilters(this.getFilters("procinstid"));
        commandContext.getTrdProcRelationEntityManager().deleteByFilters(this.getFilters("procinstid"));
        commandContext.getExeConversionEntityManager().deleteByFilters(this.getFilters("procinstid"));
        commandContext.getHistoricConditionRuleInstanceEntityManager().deleteHisCondRuleInstByProcInstId(this.processInstanceId);
        commandContext.getJobEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getFailedJobEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getTimerJobEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getDeadLetterJobEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getHistoricJobRecordEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getSuspendedJobEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getEventLogEntryEntityManager().deleteByFilters(qFilters);
        commandContext.getDetailLogEntityManager().deleteByFilters(this.getFilters("procinstid"));
        commandContext.getTaskHandleLogEntityManager().deleteByFilters(this.getFilters("processInstanceId"));
        commandContext.getDurationDetailEntityManager().deleteByFilters(this.getFilters(PROCESSINSTANCEID));
        commandContext.getOperationLogEntityManager().deleteByFilters(this.getFilters("procinstid"));
        commandContext.getEntityManager(RuntimeParseLogManager.class).deleteByFilters(qFilters);
        commandContext.getEntityManager(EVENTLOGENTRYESENTITYMANAGER).deleteByFilters(qFilters);
        WfUtils.addOpLog("wf_execution", "delete", new MultiLangEnumBridge("\u5220\u9664\u6d41\u7a0b", "DeleteAllRuntimeDatasByProcessInstanceIdCmd_2", "bos-wf-engine"), null, String.format("proInstanceId:[%s]", this.processInstanceId));
        if (execution != null) {
            commandContext.getMessageService().sendProcessInstanceAsync(this.processInstanceId, TERMINATE);
        }
    }

    private QFilter[] getFilters(String property) {
        return new QFilter[]{new QFilter(property, "=", (Object)this.processInstanceId)};
    }
}

