/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class FilterBusinessKeysInBizFlow
extends AbstractBatchQueryCmd<Map<String, Set<Long>>> {
    private List<String> bks;

    public FilterBusinessKeysInBizFlow(List<String> businessKeys) {
        this.bks = businessKeys;
    }

    @Override
    protected void handleResult(Map<String, Set<Long>> ret, Row row) {
        String bk = row.getString("fbusinesskey");
        if (!WfUtils.isEmpty(bk)) {
            Set<Long> set = ret.get(bk);
            if (set == null) {
                set = new HashSet<Long>(4);
            }
            set.add(row.getLong("fprocinstid"));
            ret.put(bk, set);
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select fbusinesskey,fprocinstid,fentitynumber from t_wf_execution").append(" where  FBUSINESSKEY in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sb.append(" ?");
            if (i == length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        sb.append(" and FISACTIVE = '1' and FPROCESSTYPE='BizFlow' ");
        return sb.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return this.bks;
    }

    @Override
    protected Map<String, Set<Long>> createRet() {
        return new HashMap<String, Set<Long>>();
    }
}

