/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;

public class GetBizProcessStatusByNameCmd
extends AbstractBatchQueryCmd<Map<String, List<BizProcessStatus>>> {
    private String[] businessKeys;
    private String name;
    private Map<String, List<String>> tmp;
    private static final String WFINTERFACELIMITINAUDITFLOW = "wf.interface.limit.in.auditFlow";

    public GetBizProcessStatusByNameCmd(String[] businessKeys, String name) {
        this.businessKeys = (String[])businessKeys.clone();
        this.count = 1000;
        this.name = name;
        this.tmp = new HashMap<String, List<String>>(this.count);
    }

    private String getStatusName(String status) {
        return SuspensionState.SuspensionStateUtil.getStateCaption(status);
    }

    @Override
    protected void handleResult(Map<String, List<BizProcessStatus>> ret, Row r) {
        String[] participantNames;
        String status = r.getString("FSUSPENSIONSTATE");
        String statusName = this.getStatusName(status);
        String participantName = r.getString("PARTICIPANTNAME");
        String businessKey = r.getString("fbusinesskey");
        String activityId = r.getString("factid");
        String activityName = r.getString("activityname");
        List<BizProcessStatus> bizProcesses = ret.get(businessKey);
        if (bizProcesses == null) {
            bizProcesses = new ArrayList<BizProcessStatus>(4);
            ret.put(businessKey, bizProcesses);
        }
        if (WfUtils.isEmpty(activityId)) {
            return;
        }
        String[] actIds = activityId.split(",");
        String[] actNames = activityName.split(StandardTips.getComma());
        if (actNames.length != actIds.length) {
            actNames = activityName.split(",");
        }
        ArrayList<String> callActivityActNames = new ArrayList<String>(actNames.length);
        for (int i = 0; i < actIds.length; ++i) {
            String[] actId = actIds[i];
            String actName = actNames[i];
            if (!actId.contains("CallActivity")) continue;
            callActivityActNames.add(actName);
        }
        for (String participant : participantNames = this.getParticipantNames(businessKey, callActivityActNames, participantName)) {
            String actName;
            if (WfUtils.isEmpty(participant) || WfUtils.isNotEmpty(this.name) && !participant.contains(this.name)) continue;
            String partName = null;
            if (participant.contains("\uff0f")) {
                actName = participant.substring(0, participant.indexOf("\uff0f"));
                if (participant.indexOf("\uff0f") != participant.length() - 1) {
                    partName = participant.substring(participant.indexOf("\uff0f") + 1);
                }
            } else {
                actName = participant;
            }
            bizProcesses.add(new BizProcessStatus(status, statusName, partName, actName));
        }
        this.tmp.putIfAbsent(businessKey, new ArrayList(10));
        List<String> participantNameList = this.tmp.get(businessKey);
        if (participantNameList != null) {
            participantNameList.add(participantName);
        }
    }

    private String[] getParticipantNames(String businessKey, List<String> callActivityActNames, String participantName) {
        for (String actName : callActivityActNames) {
            if (!WfUtils.isNotEmptyForCollection(this.tmp.get(businessKey))) continue;
            for (String oldParticipant : this.tmp.get(businessKey)) {
                String matcher = String.format("%s(%s)", actName, oldParticipant);
                participantName = participantName.replace(matcher, "");
            }
        }
        return participantName.split("\uff1b");
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        this.tmp.clear();
        String lang = RequestContext.get().getLang().toString();
        String taskTableAlias = "a";
        String taskMultiLangTableAlias = "b";
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", taskTableAlias, taskMultiLangTableAlias, "factivityname", "activityname", "activityname");
        String participantNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", taskTableAlias, taskMultiLangTableAlias, "FPRESENTASSIGNEE", "participantname", "participantname");
        StringBuilder sql = new StringBuilder();
        sql.append("select  a.fbusinesskey,a.fsuspensionstate,a.fprocesstype,a.factid,a.fid,").append(activityNameSQL).append(", ").append(participantNameSQL);
        sql.append(" from t_wf_execution a  LEFT JOIN t_wf_execution_l b on a.fid = b.fid ");
        sql.append(" AND b.FLOCALEID = ").append("'").append(lang).append("'");
        Object interfaceLimitInAuditFlow = WfConfigurationUtil.getConfigCenterVal(WFINTERFACELIMITINAUDITFLOW);
        if (interfaceLimitInAuditFlow == null) {
            sql.append(" where a.fprocesstype ='").append(ProcessType.AuditFlow).append("' and a.fbusinesskey in (");
        } else {
            sql.append(" where a.fbusinesskey in (");
        }
        int length = subList.size();
        StringBuilder queryBuilder = new StringBuilder(sql);
        for (int i = 0; i < length; ++i) {
            queryBuilder.append(" ?");
            if (i == length - 1) continue;
            queryBuilder.append(',');
        }
        queryBuilder.append(')');
        queryBuilder.append(" and fisscope = '1' order by fid desc");
        return queryBuilder.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return Arrays.asList(this.businessKeys);
    }

    @Override
    protected Map<String, List<BizProcessStatus>> createRet() {
        return new HashMap<String, List<BizProcessStatus>>();
    }
}

