/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class GetBizProcessStatusCmd
extends AbstractBatchQueryCmd<Map<String, List<BizProcessStatus>>> {
    private String[] businessKeys = null;
    private Map<String, Boolean> tmp = new HashMap<String, Boolean>(8);
    private static final String WFINTERFACELIMITINAUDITFLOW = "wf.interface.limit.in.auditFlow";

    public GetBizProcessStatusCmd(String[] businessKeys) {
        this.businessKeys = (String[])businessKeys.clone();
        this.count = 1000;
    }

    private String getStatusName(String status) {
        return SuspensionState.SuspensionStateUtil.getStateCaption(status);
    }

    @Override
    protected void handleResult(Map<String, List<BizProcessStatus>> ret, Row r) {
        String key;
        Long parentTaskId;
        String status = r.getString("FSUSPENSIONSTATE");
        String statusName = this.getStatusName(status);
        String nodeName = r.getString("name");
        String participantName = r.getString("PARTICIPANTNAME");
        String businesskey = r.getString("fbusinesskey");
        String category = r.getString("fcategory");
        Long taskid = r.getLong("fid");
        if (WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofYunzhijiaTask(category) && WfUtils.isEmpty(parentTaskId = r.getLong("fparenttaskid"))) {
            return;
        }
        List<BizProcessStatus> bizProcesses = ret.get(businesskey);
        if (bizProcesses == null) {
            bizProcesses = new ArrayList<BizProcessStatus>(4);
        }
        if (!this.tmp.containsKey(key = String.format("%s-%s", businesskey, taskid)) && WfUtils.isNotEmpty(nodeName)) {
            bizProcesses.add(new BizProcessStatus(status, statusName, participantName, nodeName));
            this.tmp.put(key, Boolean.TRUE);
            ret.put(businesskey, bizProcesses);
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        String lang = RequestContext.get().getLang().toString();
        String taskTableAlias = "a";
        String taskMultiLangTableAlias = "b";
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", taskTableAlias, taskMultiLangTableAlias, "fname", "name", "name");
        String participantNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", taskTableAlias, taskMultiLangTableAlias, "FPARTICIPANTNAME", "participantname", "participantname");
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fbusinesskey,a.fsuspensionstate,a.fprocesstype,a.fcategory,a.fparenttaskid,a.fid,").append(activityNameSQL).append(", ").append(participantNameSQL);
        sql.append(" from t_wf_task a  LEFT JOIN t_wf_task_l b on a.fid = b.fid ");
        sql.append(" AND b.FLOCALEID = ").append("'").append(lang).append("'");
        Object interfaceLimitInAuditFlow = WfConfigurationUtil.getConfigCenterVal(WFINTERFACELIMITINAUDITFLOW);
        if (interfaceLimitInAuditFlow == null) {
            sql.append(" where a.fprocesstype ='").append(ProcessType.AuditFlow).append("' and a.fbusinesskey in (");
        } else {
            sql.append(" where a.fbusinesskey in (");
        }
        int length = subList.size();
        StringBuilder queryBuilder = new StringBuilder(sql);
        for (int i = 0; i < length; ++i) {
            queryBuilder.append(" ?");
            if (i == length - 1) continue;
            queryBuilder.append(',');
        }
        queryBuilder.append(')');
        return queryBuilder.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return Arrays.asList(this.businessKeys);
    }

    @Override
    protected Map<String, List<BizProcessStatus>> createRet() {
        return new HashMap<String, List<BizProcessStatus>>();
    }
}

