/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class GetInProcessPkCmd
extends AbstractBatchQueryCmd<Collection<ExtendedDataEntity>> {
    private Map<String, ExtendedDataEntity> notInCacheEntitys;

    public GetInProcessPkCmd(Map<String, ExtendedDataEntity> notInCacheEntitys) {
        this.notInCacheEntitys = notInCacheEntitys;
    }

    @Override
    protected void handleResult(Collection<ExtendedDataEntity> ret, Row r) {
        String pk = r.getString("pk");
        if (this.notInCacheEntitys.containsKey(pk)) {
            ret.add(this.notInCacheEntitys.get(pk));
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select FBUSINESSKEY pk from t_wf_execution").append(" where  FBUSINESSKEY in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sb.append(" ?");
            if (i == length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        sb.append(" and FISSCOPE = '1' and FISACTIVE = '1' and FPROCESSTYPE='AuditFlow' ");
        return sb.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return this.notInCacheEntitys.keySet();
    }

    @Override
    protected Collection<ExtendedDataEntity> createRet() {
        return new ArrayList<ExtendedDataEntity>();
    }
}

