/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class GetProcInstIdsByEntityNumberOrBusinessKeyCmd
implements Command<List>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int start;
    private int limit;
    private String entityNumber;
    private String businessKey;

    public GetProcInstIdsByEntityNumberOrBusinessKeyCmd(int start, int limit, String entityNumber, String businessKey) {
        this.entityNumber = entityNumber;
        this.businessKey = businessKey;
        this.start = start;
        this.limit = limit;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        QFilter f1;
        if (this.limit <= 0 || WfUtils.isEmpty(this.entityNumber) && WfUtils.isEmpty(this.businessKey)) {
            return Collections.emptyList();
        }
        if (this.limit > 10000) {
            this.limit = 10000;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (WfUtils.isNotEmpty(this.entityNumber)) {
            f1 = new QFilter("entitynumber", "=", (Object)this.entityNumber);
            filters.add(f1);
        }
        if (WfUtils.isNotEmpty(this.businessKey)) {
            f1 = new QFilter("businessKey", "=", (Object)this.businessKey);
            filters.add(f1);
        }
        EntityQueryBuilder eb = commandContext.getHistoricProcessInstanceEntityManager().createQueryBuilder();
        QFilter[] qFilters = filters.toArray(new QFilter[0]);
        eb.setSelectFields("id");
        eb.addFilters(qFilters);
        eb.setStart(this.start).setLimit(this.limit);
        List list = commandContext.getHistoricProcessInstanceEntityManager().findByQueryBuilder(eb);
        ArrayList<Long> procInstIds = new ArrayList<Long>(list.size());
        for (HistoricProcessInstanceEntity entity : list) {
            procInstIds.add(entity.getId());
        }
        return procInstIds;
    }
}

