/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class GetProcInstIdsByProcDefIdCmd
implements Command<List>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long procDefId;
    private int start;
    private int limit;

    public GetProcInstIdsByProcDefIdCmd(int start, int limit, Long procDefId) {
        this.procDefId = procDefId;
        this.start = start;
        this.limit = limit;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        ArrayList<Long> procInstIds = new ArrayList<Long>();
        if (WfUtils.isEmpty(this.procDefId)) {
            return procInstIds;
        }
        if (this.limit > 0) {
            if (this.limit > 10000) {
                this.limit = 10000;
            }
            EntityQueryBuilder eb = commandContext.getHistoricProcessInstanceEntityManager().createQueryBuilder();
            QFilter[] filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)this.procDefId)};
            eb.setSelectFields("id");
            eb.addFilters(filters);
            eb.setStart(this.start).setLimit(this.limit);
            List list = commandContext.getHistoricProcessInstanceEntityManager().findByQueryBuilder(eb);
            for (HistoricProcessInstanceEntity entity : list) {
                procInstIds.add(entity.getId());
            }
        }
        return procInstIds;
    }
}

