/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class RemoveJointAuditParticipantsCmd
implements Command<Void> {
    private String businesskey;
    private String nodeId;
    private List<Long> participants;

    public RemoveJointAuditParticipantsCmd(String businesskey, String nodeId, List<Long> participants) {
        this.businesskey = businesskey;
        this.nodeId = nodeId;
        this.participants = participants;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.businesskey) || WfUtils.isEmpty(this.nodeId) || this.participants == null || this.participants.isEmpty()) {
            throw new IllegalArgumentException("invalid parameters.");
        }
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTaskIdByBusinessKeyAndNodeId(this.businesskey, this.nodeId);
        if (tasks == null || tasks.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u5fc5\u987b\u4e3a\u5f53\u524d\u8282\u70b9\u3002", (String)"RemoveJointAuditParticipantsCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        TaskEntity task = tasks.get(0);
        if (!BpmnModelUtil.instanceofYunzhijiaTask(task.getCategory())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u5fc5\u987b\u662f\u4f1a\u5ba1\u8282\u70b9\u3002", (String)"RemoveJointAuditParticipantsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        RunTimeLog.get().init(SceneType.YUNZHIJIEPARTICIPANTREMOVEBYJOGGLE, LogClassType.PARTICIPANT_LOG_BLOCK);
        FlowElement elem = ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), this.nodeId);
        if (elem instanceof YunzhijiaTask) {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_1.getDesc(), task.getName()));
            Object behavior = ((YunzhijiaTask)elem).getBehavior();
            if (behavior instanceof ParallelMultiInstanceBehavior) {
                this.removeJointAuditParticipantsForParallel(commandContext, task, behavior);
            } else if (behavior instanceof SequentialMultiInstanceBehavior) {
                this.removeJointAuditParticipantsForSequential(commandContext, task, behavior);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u5fc5\u987b\u662f\u4f1a\u5ba1\u8282\u70b9\u3002", (String)"RemoveJointAuditParticipantsCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        RunTimeLog.get().endBlock();
        RunTimeLog.get().end(task);
        return null;
    }

    private void removeJointAuditParticipantsForSequential(CommandContext commandContext, TaskEntity task, Object behavior) {
        if (task.getExecution() == null) {
            return;
        }
        String ids = (String)task.getVariableLocal("teamMembers");
        ArrayList<Long> userIds = new ArrayList<Long>(this.participants.size());
        userIds.addAll(WfUtils.stringToCollection(ids, ","));
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_2.getDesc(), RunTimeLog.get().collectAndSubstitution((List)WfUtils.stringToCollection(ids, ","), "user")));
        int loopCounter = 0;
        if (task.getExecution().getVariable("loopCounter") != null) {
            loopCounter = (Integer)task.getExecution().getVariable("loopCounter");
        }
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_4.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
        Iterator userIdsIter = userIds.iterator();
        int i = 0;
        ArrayList<Long> removeUserIds = new ArrayList<Long>(userIds.size());
        while (userIdsIter.hasNext()) {
            Long userId = (Long)userIdsIter.next();
            if (i <= loopCounter) {
                ++i;
                continue;
            }
            if (!this.participants.contains(userId)) continue;
            removeUserIds.add(userId);
            userIdsIter.remove();
        }
        ILocaleString participantName = commandContext.getProcessEngineConfiguration().getTaskHelper().getParticipantName(userIds);
        ILocaleString participantNameFormater = ParticipantHelper.getUserNameFormatValue(task, userIds);
        task.setVariableLocal("teamMembers", WfUtils.listToString(userIds, ","));
        if (WfUtils.isNotEmpty(participantName)) {
            task.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)participantName));
        }
        if (WfUtils.isNotEmpty(participantNameFormater)) {
            task.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_6.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
        ((SequentialMultiInstanceBehavior)behavior).removeInstances(task, removeUserIds);
    }

    protected void removeJointAuditParticipantsForParallel(CommandContext commandContext, TaskEntity task, Object behavior) {
        if (task.getExecution() != null) {
            String ids = (String)task.getVariableLocal("teamMembers");
            HashSet<Long> userIds = new HashSet<Long>(this.participants.size());
            userIds.addAll(WfUtils.stringToCollection(ids, ","));
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_2.getDesc(), RunTimeLog.get().collectAndSubstitution((List)WfUtils.stringToCollection(ids, ","), "user")));
            Boolean match = false;
            Iterator iter = userIds.iterator();
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_4.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
            while (iter.hasNext()) {
                if (!this.participants.contains(iter.next())) continue;
                iter.remove();
                match = true;
            }
            if (match.booleanValue()) {
                ILocaleString participantNameFormater;
                task.setVariableLocal("teamMembers", WfUtils.listToString(userIds, ","));
                ArrayList<Long> t = new ArrayList<Long>(userIds);
                ILocaleString participantName = commandContext.getProcessEngineConfiguration().getTaskHelper().getParticipantName(t);
                if (WfUtils.isNotEmpty(participantName)) {
                    task.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)participantName));
                }
                if (WfUtils.isNotEmpty(participantNameFormater = ParticipantHelper.getUserNameFormatValue(task, userIds))) {
                    task.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
                }
                ((ParallelMultiInstanceBehavior)behavior).removeInstances(task, this.participants);
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.REMOVEPARTICIPANT_6.getDesc(), RunTimeLog.get().collectAndSubstitution(this.participants, "user")));
        }
    }
}

