/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class RemoveOnlyInBizFlowPkCmd
extends AbstractBatchQueryCmd<Collection<ExtendedDataEntity>> {
    private Map<String, ExtendedDataEntity> inCacheEntitys;
    private Map<String, String> onlyBizFlow = null;

    public RemoveOnlyInBizFlowPkCmd(Map<String, ExtendedDataEntity> notInCacheEntitys) {
        this.inCacheEntitys = notInCacheEntitys;
        this.onlyBizFlow = new HashMap<String, String>();
    }

    @Override
    protected void handleResult(Collection<ExtendedDataEntity> ret, Row r) {
        String pk = r.getString("pk");
        String pType = r.getString("pType");
        if (ModelType.AuditFlow.name().equalsIgnoreCase(pType)) {
            this.onlyBizFlow.put(pk, "1");
        } else if (ModelType.BizFlow.name().equalsIgnoreCase(pType) && this.onlyBizFlow.get(pk) == null) {
            this.onlyBizFlow.put(pk, "2");
        }
    }

    @Override
    protected void afterHandlerRet(Collection<ExtendedDataEntity> ret) {
        for (Map.Entry<String, ExtendedDataEntity> entry : this.inCacheEntitys.entrySet()) {
            if (this.onlyBizFlow.get(entry.getKey()) != null && "2".equalsIgnoreCase(this.onlyBizFlow.get(entry.getKey()))) continue;
            ret.add(this.inCacheEntitys.get(entry.getKey()));
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select FBUSINESSKEY pk,FPROCESSTYPE pType from t_wf_execution").append(" where  FBUSINESSKEY in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sb.append(" ?");
            if (i == length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return this.inCacheEntitys.keySet();
    }

    @Override
    protected Collection<ExtendedDataEntity> createRet() {
        return new ArrayList<ExtendedDataEntity>();
    }
}

