/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.FilterBusinessKeysInBizFlow;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class TryCloseBizFlowCmd
implements Command<Void> {
    private List<String> bos;

    public TryCloseBizFlowCmd(List<String> bos) {
        this.bos = bos;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.bos == null || this.bos.isEmpty()) {
            return null;
        }
        Map apBills = (Map)new FilterBusinessKeysInBizFlow(this.bos).execute(commandContext);
        if (apBills == null || apBills.isEmpty()) {
            return null;
        }
        Set set = apBills.entrySet();
        Iterator iter = set.iterator();
        QFilter[] qFilters = null;
        ArrayList<Long> existProc = new ArrayList<Long>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Set pros = (Set)entry.getValue();
            if (pros == null || pros.isEmpty()) continue;
            for (Long procId : pros) {
                if (!this.canClose(procId) || existProc.contains(procId)) continue;
                existProc.add(procId);
                qFilters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)procId), new QFilter("active", "=", (Object)Boolean.TRUE), new QFilter("billexecution", "=", (Object)Boolean.FALSE), new QFilter("scope", "=", (Object)Boolean.FALSE), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
                List execs = commandContext.getExecutionEntityManager().findByQueryFilters(qFilters);
                if (execs == null || execs.isEmpty()) continue;
                ExecutionEntity ee = (ExecutionEntity)execs.get(0);
                ILocaleString name = WfUtils.getPromptWordLocaleString("\u4e1a\u52a1\u5b8c\u7ed3", "TerminateProcessor_4", "bos-wf-engine");
                new AbandonProcessCmd(name, "meetBillClose", null, ee).execute(commandContext);
            }
        }
        return null;
    }

    private boolean canClose(Long procInstanceId) {
        return DynamicFlowUtil.matchCloseCondition(Context.getCommandContext(), procInstanceId);
    }
}

