/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.pojo.BusinessObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntityManager;

public class TryMountTargetBySrcBillCmd
implements Command<Void> {
    private Map<String, List<BusinessObject>> targets;

    public TryMountTargetBySrcBillCmd(Map<String, List<BusinessObject>> targets) {
        this.targets = targets;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.targets == null || this.targets.isEmpty()) {
            return null;
        }
        CirculateRelationEntityManager manager = commandContext.getCirculateRelationEntityManager();
        HashSet<String> tarIds = new HashSet<String>(this.targets.size());
        HashSet<String> srcIds = new HashSet<String>(this.targets.size());
        Set<Map.Entry<String, List<BusinessObject>>> set = this.targets.entrySet();
        for (Map.Entry<String, List<BusinessObject>> bo : set) {
            List<BusinessObject> entrys = bo.getValue();
            if (WfUtils.isEmptyForCollection(entrys)) continue;
            for (BusinessObject entry : entrys) {
                tarIds.add(entry.getBusinessKey());
            }
            srcIds.add(bo.getKey());
        }
        List<CirculateRelationEntity> crs = manager.findCirculateRelationsByBusinessKeys(tarIds);
        HashMap<String, Boolean> tmp = new HashMap<String, Boolean>();
        if (crs != null && !crs.isEmpty()) {
            for (CirculateRelationEntity entity : crs) {
                tmp.put(String.format("%s%s%s", entity.getBizTraceNo(), entity.getBusinessKey(), entity.getSourceBillId()), Boolean.TRUE);
            }
        }
        List<CirculateRelationEntity> res = manager.findCirculateRelationsByBusinessKeys(srcIds);
        String key = null;
        for (CirculateRelationEntity src : res) {
            List<BusinessObject> bos = this.targets.get(src.getBusinessKey());
            for (BusinessObject bo : bos) {
                key = String.format("%s%s%s", src.getBizTraceNo(), bo.getBusinessKey(), src.getBusinessKey());
                if (tmp.containsKey(key)) continue;
                commandContext.getCirculateRelationEntityManager().createCirculateRelationEntity(src, bo);
            }
        }
        return null;
    }
}

