/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.execution;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class UpdateForBatchAutoImportCmd
implements Command<Void> {
    private Date start;
    private Date end;
    private int userAmount;
    private Log log = LogFactory.getLog(this.getClass());
    private static final int BATCH_COUNT = 100;

    public UpdateForBatchAutoImportCmd(Date start, Date end, int userAmount) {
        this.start = start;
        this.end = end;
        this.userAmount = userAmount;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.batchUpdateData(this.start, this.end, this.userAmount);
        return null;
    }

    public void batchUpdateData(Date start, Date end, int userAmount) {
        List userList = QueryServiceHelper.queryPrimaryKeys((String)"bos_user", null, null, (int)userAmount);
        this.update4Wf(start, end, userList);
        this.update4HiMsg(start, end, userList);
        this.update4Msg(start, end, userList);
    }

    private void update4Wf(Date start, Date end, List<Object> userList) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        QFilter[] filters = new QFilter[]{new QFilter("billno", "like", (Object)"auto_import%")};
        List hisProcessEntities = service.getRepositoryService().findEntitiesByFilters("wf_hiprocinst", filters);
        if (WfUtils.isEmptyForCollection(hisProcessEntities)) {
            return;
        }
        int wfdataqty = hisProcessEntities.size();
        long duration = end.getTime() - start.getTime();
        long wfInterval = duration / (long)wfdataqty;
        long time = start.getTime();
        String taskSql = "UPDATE t_wf_task SET FSTARTERID = ?, FSENDERID = ?, FCREATEDATE = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> taskParams = new ArrayList<Object[]>(100);
        String executionSql = "UPDATE t_wf_execution SET FSTARTUSERID = ?, FCREATORID = ?, FMODIFIERID = ?, FCREATEDATE = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> executionParams = new ArrayList<Object[]>(100);
        String hiprocinstSql = "UPDATE t_wf_hiprocinst SET FSTARTUSERID = ?, FCREATORID = ?, FMODIFIERID = ?, FCREATEDATE = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> hiprocinstParams = new ArrayList<Object[]>(100);
        String hicommentSql = "UPDATE t_wf_hicomment SET FTIME = ?, FUSERID = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> hicommentParams = new ArrayList<Object[]>(100);
        String participantSql = "UPDATE t_wf_participant SET FUSERID = ?, FCREATEDATE = ? WHERE FPROCINSTID = ?;";
        ArrayList<Object[]> participantParams = new ArrayList<Object[]>(100);
        String hitaskInstSql = "UPDATE t_wf_hitaskinst SET FASSIGNEE = ?, FSTARTERID = ?, FCREATEDATE = ?, FENDTIME = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> hitaskinstParams = new ArrayList<Object[]>(100);
        String hiparticipantSql = "UPDATE t_wf_hiparticipant SET FUSERID = ?, FCREATEDATE = ?, FENDTIME = ? WHERE FPROCINSTID = ?;";
        ArrayList<Object[]> hiparticipantParams = new ArrayList<Object[]>(100);
        String hiactinstSql = "UPDATE t_wf_hiactinst SET FASSIGNEE = ?, FCREATEDATE = ?, FENDTIME = ? WHERE FPROCINSTID = ?;";
        ArrayList<Object[]> hiactinstParams = new ArrayList<Object[]>(100);
        String evtlogSql = "UPDATE t_wf_evtlog SET FUSERID = ?, FTIMESTAMP = ?, FCREATEDATE = ? WHERE FBUSINESSKEY = ?;";
        ArrayList<Object[]> evtlogParams = new ArrayList<Object[]>(100);
        this.log.debug("\u5f00\u59cb\u66f4\u65b0\u5de5\u4f5c\u6d41\u76f8\u5173\u8868");
        StringBuilder logSb = new StringBuilder();
        for (int i = 0; i < wfdataqty; ++i) {
            String businessKey = ((HistoricProcessInstanceEntity)hisProcessEntities.get(i)).getBusinessKey();
            long procinstid = ((HistoricProcessInstanceEntity)hisProcessEntities.get(i)).getProcessInstanceId();
            Date newDate = new Date(time);
            time += wfInterval;
            long user = (Long)userList.get(i % userList.size());
            taskParams.add(new Object[]{user, user, newDate, businessKey});
            executionParams.add(new Object[]{user, user, user, newDate, businessKey});
            hiprocinstParams.add(new Object[]{user, user, user, newDate, businessKey});
            hicommentParams.add(new Object[]{newDate, user, businessKey});
            participantParams.add(new Object[]{user, newDate, procinstid});
            hitaskinstParams.add(new Object[]{user, user, newDate, newDate, businessKey});
            hiparticipantParams.add(new Object[]{user, newDate, newDate, procinstid});
            hiactinstParams.add(new Object[]{user, newDate, newDate, procinstid});
            evtlogParams.add(new Object[]{user, newDate, newDate, businessKey});
            if ((wfdataqty >= 100 || i != wfdataqty - 1) && (i + 1) % 100 != 0) continue;
            try (TXHandle h = TX.required();){
                this.log.debug(WFMultiLangConstants.getUpdating() + "(" + (i + 1) + ")");
                int taskSucc = WfUtils.executeBatch(taskSql, taskParams, 100);
                logSb.append("T_WF_TASK update success ").append(taskSucc).append(",");
                int executeSucc = WfUtils.executeBatch(executionSql, executionParams, 100);
                logSb.append("T_WF_EXECUTION update success ").append(executeSucc).append(",");
                int hiprocinstSucc = WfUtils.executeBatch(hiprocinstSql, hiprocinstParams, 100);
                logSb.append("T_WF_HIPROCINST update success ").append(hiprocinstSucc).append(",");
                int hicommentSucc = WfUtils.executeBatch(hicommentSql, hicommentParams, 100);
                logSb.append("T_WF_HICOMMENT update success ").append(hicommentSucc).append(",");
                int participantSucc = WfUtils.executeBatch(participantSql, participantParams, 100);
                logSb.append("T_WF_PARTICIPANT update success ").append(participantSucc).append(",");
                int hitaskinstSucc = WfUtils.executeBatch(hitaskInstSql, hitaskinstParams, 100);
                logSb.append("T_WF_HITASKINST update success ").append(hitaskinstSucc).append(",");
                int hiparticipantSucc = WfUtils.executeBatch(hiparticipantSql, hiparticipantParams, 100);
                logSb.append("T_WF_HIPARTICIPANT update success ").append(hiparticipantSucc).append(",");
                int hiactinstSucc = WfUtils.executeBatch(hiactinstSql, hiactinstParams, 100);
                logSb.append("T_WF_HIACTINST update success ").append(hiactinstSucc).append(",");
                int evtlogSucc = WfUtils.executeBatch(evtlogSql, evtlogParams, 100);
                logSb.append("T_WF_EVTLOG update success ").append(evtlogSucc).append(",");
                logSb.append("update finished(").append(i + 1).append(")");
            }
            this.log.debug(logSb.toString());
            taskParams.clear();
            executionParams.clear();
            hiprocinstParams.clear();
            hicommentParams.clear();
            participantParams.clear();
            hitaskinstParams.clear();
            hiparticipantParams.clear();
            hiactinstParams.clear();
            evtlogParams.clear();
        }
        this.log.debug("\u5de5\u4f5c\u6d41\u76f8\u5173\u8868\u66f4\u65b0\u5b8c\u6210");
    }

    private void update4HiMsg(Date start, Date end, List<Object> userList) {
        QFilter[] filter4Content = new QFilter[]{new QFilter("content", "=", (Object)"auto_import")};
        DynamicObject[] himessageDynamicObjects = BusinessDataServiceHelper.load((String)"wf_msg_himessage", (String)"id", (QFilter[])filter4Content);
        if (WfUtils.isEmptyForArrays(himessageDynamicObjects)) {
            return;
        }
        int hiMsgQty = himessageDynamicObjects.length;
        String himessageSql = "UPDATE t_wf_himessage SET FSENDTIME = ?, FCREATEDATE = ? WHERE FID = ?;";
        ArrayList<Object[]> himessageParams = new ArrayList<Object[]>(100);
        String himsgreceiverSql = "UPDATE t_wf_himsgreceiver SET FRECEIVERID = ? WHERE FMESSAGEID = ?;";
        ArrayList<Object[]> himsgreceiverParams = new ArrayList<Object[]>(100);
        long duration = end.getTime() - start.getTime();
        long himsgInterval = duration / (long)hiMsgQty;
        long time = start.getTime();
        this.log.debug("\u5f00\u59cb\u66f4\u65b0\u5386\u53f2\u6d88\u606f\u76f8\u5173\u8868");
        for (int i = 0; i < hiMsgQty; ++i) {
            Date newDate = new Date(time);
            time += himsgInterval;
            long user = (Long)userList.get(i % userList.size());
            Long pk = (Long)himessageDynamicObjects[i].get("id");
            himessageParams.add(new Object[]{newDate, newDate, pk});
            himsgreceiverParams.add(new Object[]{user, pk});
            if ((hiMsgQty >= 100 || i != hiMsgQty - 1) && (i + 1) % 100 != 0) continue;
            try (TXHandle h = TX.required();){
                this.log.debug(WFMultiLangConstants.getUpdating() + "(" + (i + 1) + ")");
                int himessageSucc = WfUtils.executeBatch(himessageSql, himessageParams, 100);
                this.log.debug("T_WF_HIMESSAGE\u66f4\u65b0\u6210\u529f\uff1a" + himessageSucc);
                int himsgreceiverSucc = WfUtils.executeBatch(himsgreceiverSql, himsgreceiverParams, 100);
                this.log.debug("T_WF_HIMSGRECEIVER\u66f4\u65b0\u6210\u529f\uff1a" + himsgreceiverSucc);
            }
            himessageParams.clear();
            himsgreceiverParams.clear();
        }
        this.log.debug("\u5386\u53f2\u6d88\u606f\u76f8\u5173\u8868\u66f4\u65b0\u5b8c\u6210");
    }

    private void update4Msg(Date start, Date end, List<Object> userList) {
        QFilter[] filter4Content = new QFilter[]{new QFilter("content", "=", (Object)"auto_import")};
        DynamicObject[] messageDynamicObjects = BusinessDataServiceHelper.load((String)"wf_msg_message", (String)"id", (QFilter[])filter4Content);
        if (WfUtils.isEmptyForArrays(messageDynamicObjects)) {
            return;
        }
        int msgQty = messageDynamicObjects.length;
        String messageSql = "UPDATE t_wf_message SET FSENDTIME = ?, FCREATEDATE = ? WHERE FID = ?;";
        ArrayList<Object[]> messageParams = new ArrayList<Object[]>(100);
        String msgreceiverSql = "UPDATE t_wf_msgreceiver SET FRECEIVERID = ? WHERE FMESSAGEID = ?;";
        ArrayList<Object[]> msgreceiverParams = new ArrayList<Object[]>(100);
        long duration = end.getTime() - start.getTime();
        long time = start.getTime();
        long msgInterval = duration / (long)msgQty;
        this.log.debug("\u5f00\u59cb\u66f4\u65b0\u6d88\u606f\u76f8\u5173\u8868");
        for (int i = 0; i < msgQty; ++i) {
            Date newDate = new Date(time);
            time += msgInterval;
            long user = (Long)userList.get(i % userList.size());
            Long pk = (Long)messageDynamicObjects[i].get("id");
            messageParams.add(new Object[]{newDate, newDate, pk});
            msgreceiverParams.add(new Object[]{user, pk});
            if ((msgQty >= 100 || i != msgQty - 1) && (i + 1) % 100 != 0) continue;
            try (TXHandle h = TX.required();){
                this.log.debug(WFMultiLangConstants.getUpdating() + "(" + (i + 1) + ")");
                int messageSucc = WfUtils.executeBatch(messageSql, messageParams, 100);
                this.log.debug("T_WF_MESSAGE\u66f4\u65b0\u6210\u529f\uff1a" + messageSucc);
                int msgreceiverSucc = WfUtils.executeBatch(msgreceiverSql, msgreceiverParams, 100);
                this.log.debug("T_WF_MSGRECEIVER\u66f4\u65b0\u6210\u529f\uff1a" + msgreceiverSucc);
            }
            messageParams.clear();
            msgreceiverParams.clear();
        }
        this.log.debug("\u6d88\u606f\u76f8\u5173\u8868\u66f4\u65b0\u5b8c\u6210");
    }

    private String getFormatDate(Date date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }
}

