/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricJobRecordEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;

public class ClearFinishedProcessJobsCmd
implements Command<Void> {
    private List<String> businessKeys;

    public ClearFinishedProcessJobsCmd(List<String> businessKeys) {
        this.businessKeys = businessKeys;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.businessKeys)) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>(this.businessKeys.size());
        for (String businessKey : this.businessKeys) {
            params.add(businessKey);
        }
        String batchSql = "DELETE FROM T_WF_JOBRECORD WHERE FHANDLERTYPE = 'async-timing' AND FBUSINESSKEY IN (?);";
        WfDBUtils.executeBatchDeleteByIn(batchSql, params, 500, true);
        ArrayList<String> stateList = new ArrayList<String>(3);
        stateList.add(JobStateEnum.COMPLETED.getNumber());
        stateList.add(JobStateEnum.ERRORED.getNumber());
        QFilter[] filter = new QFilter[]{new QFilter("state", "in", stateList), new QFilter("businessKey", "in", this.businessKeys)};
        List jobEntityList = commandContext.getJobEntityManager().findByQueryFilters(filter);
        HistoricJobRecordEntityManager manager = commandContext.getHistoricJobRecordEntityManager();
        if (jobEntityList != null) {
            for (JobEntity jobEntity : jobEntityList) {
                manager.copyAndInsert(jobEntity);
            }
        }
        String deledteSql = "DELETE FROM T_WF_JOBRECORD WHERE FSTATE in ('completed','errored') AND FBUSINESSKEY IN (?);";
        WfDBUtils.executeBatchDeleteByIn(deledteSql, params, 500, true);
        return null;
    }
}

