/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.serialization.CollectionBinder;
import kd.bos.workflow.engine.history.serialization.CollectionSerialize;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigFactory;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigParam;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntity;

public class CompactFinishProcDatasCmd
implements Command<Void> {
    private List<Long> procInstIds;
    private EntityCompactConfigParam compactParam;

    @Deprecated
    public CompactFinishProcDatasCmd(List<Long> procInstIds) {
        this.procInstIds = procInstIds;
    }

    @Deprecated
    public CompactFinishProcDatasCmd(Long procInstId) {
        this.procInstIds = new ArrayList<Long>(1);
        this.procInstIds.add(procInstId);
    }

    public CompactFinishProcDatasCmd(List<Long> procInstIds, EntityCompactConfigParam compactParam) {
        this.procInstIds = procInstIds;
        this.compactParam = compactParam;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.procInstIds) || this.compactParam == null) {
            return null;
        }
        String compactPropertyName = this.compactParam.getCompactPropertyName();
        String selectFeilds = String.format("%s,%s,%s", "id", "processInstanceId", compactPropertyName);
        List compactedEntitys = commandContext.getHistoricProcCompactEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "in", this.procInstIds)}, selectFeilds, "id");
        ArrayList<Long> insertProcInstIds = new ArrayList(this.procInstIds.size());
        ArrayList<Long> updateProcInstIds = new ArrayList<Long>(compactedEntitys.size());
        ArrayList<HistoricProcCompactEntity> updateCompactEntitys = new ArrayList<HistoricProcCompactEntity>(compactedEntitys.size());
        if (WfUtils.isEmptyForCollection(compactedEntitys)) {
            insertProcInstIds = this.procInstIds;
        } else {
            HashMap<Long, Long> compactedProcInsts = new HashMap<Long, Long>(compactedEntitys.size());
            for (HistoricProcCompactEntity compactEntity : compactedEntitys) {
                if (WfUtils.isEmpty(compactEntity.getDynamicObject().getString(compactPropertyName))) {
                    updateProcInstIds.add(compactEntity.getProcessInstanceId());
                    updateCompactEntitys.add(compactEntity);
                }
                compactedProcInsts.put(compactEntity.getProcessInstanceId(), compactEntity.getProcessInstanceId());
            }
            for (Long procInstId : this.procInstIds) {
                if (compactedProcInsts.get(procInstId) != null) continue;
                insertProcInstIds.add(procInstId);
            }
        }
        this.insertCompactData(commandContext, insertProcInstIds);
        this.updateCompactDatas(commandContext, updateCompactEntitys, updateProcInstIds);
        return null;
    }

    private void updateCompactDatas(CommandContext commandContext, List<HistoricProcCompactEntity> updateCompactEntitys, List<Long> updateProcInstIds) {
        if (WfUtils.isEmptyForCollection(updateProcInstIds)) {
            return;
        }
        this.completeCompactPropertys(commandContext, updateCompactEntitys, updateProcInstIds);
        HistoricProcCompactEntityManager compactManager = commandContext.getHistoricProcCompactEntityManager();
        for (HistoricProcCompactEntity entity : updateCompactEntitys) {
            compactManager.update(entity);
        }
    }

    private void insertCompactData(CommandContext commandContext, List<Long> processInstanceIds) {
        if (WfUtils.isEmptyForCollection(processInstanceIds)) {
            return;
        }
        HistoricProcCompactEntityManager compactManager = commandContext.getHistoricProcCompactEntityManager();
        String feilds = "processDefinitionId,processInstanceId,businessKey,billno,entitynumber,processtype,biztraceno";
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "in", processInstanceIds)};
        List procInstList = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters, feilds, null);
        if (WfUtils.isEmptyForCollection(procInstList)) {
            return;
        }
        List<Long> enableZipProcess = WfConfigurationUtil.getEnableZipProcess();
        ArrayList<HistoricProcessInstanceEntity> initInstList = new ArrayList(procInstList.size());
        if (WfUtils.isEmptyForCollection(enableZipProcess)) {
            initInstList = procInstList;
        } else {
            processInstanceIds.clear();
            for (HistoricProcessInstanceEntity entity : procInstList) {
                if (!enableZipProcess.contains(entity.getProcessDefinitionId())) continue;
                initInstList.add(entity);
                processInstanceIds.add(entity.getProcessInstanceId());
            }
        }
        List<HistoricProcCompactEntity> compactEntitys = this.initCompactEntitys(compactManager, initInstList);
        this.completeCompactPropertys(commandContext, compactEntitys, processInstanceIds);
        for (HistoricProcCompactEntity compactEntity : compactEntitys) {
            compactManager.insert(compactEntity);
        }
        this.saveReleEntityInfos(commandContext, compactEntitys);
    }

    private void saveReleEntityInfos(CommandContext commandContext, List<HistoricProcCompactEntity> compactEntitys) {
        HistoricCompactRelaEntityManager compactRelaManager = commandContext.getHistoricCompactRelaEntityManager();
        ArrayList<Long> bizProcInstIds = new ArrayList<Long>(10);
        HashMap<Long, HistoricProcCompactEntity> bizCompactEntityMap = new HashMap<Long, HistoricProcCompactEntity>(16);
        for (HistoricProcCompactEntity compactEntity : compactEntitys) {
            if (ModelType.BizFlow.name().equalsIgnoreCase(compactEntity.getProcessType())) {
                bizProcInstIds.add(compactEntity.getProcessInstanceId());
                bizCompactEntityMap.put(compactEntity.getProcessInstanceId(), compactEntity);
                continue;
            }
            this.insertCompactRelaEntity(compactRelaManager, compactEntity.getProcessInstanceId(), compactEntity.getEntityNumber(), compactEntity.getBusinessKey());
        }
        if (!bizProcInstIds.isEmpty()) {
            this.saveBizFlowRelaEntitys(commandContext, bizProcInstIds, bizCompactEntityMap);
        }
    }

    private void saveBizFlowRelaEntitys(CommandContext commandContext, List<Long> bizProcInstIds, Map<Long, HistoricProcCompactEntity> bizCompactEntityMap) {
        List<ExeConversionEntity> conversionEntitys = commandContext.getExeConversionEntityManager().getAllConversionEntitys(bizProcInstIds);
        if (WfUtils.isEmptyForCollection(conversionEntitys)) {
            return;
        }
        HashSet<String> releEntityInfos = new HashSet<String>(conversionEntitys.size());
        HistoricCompactRelaEntityManager compactRelaManager = commandContext.getHistoricCompactRelaEntityManager();
        for (ExeConversionEntity entity : conversionEntitys) {
            Long procInstId = entity.getProcinstId();
            bizCompactEntityMap.remove(procInstId);
            String srcEntityNumber = entity.getSrcEntityNumber();
            String tagEntityNumber = entity.getTagEntityNumber();
            String srcPk = entity.getSrcBusinesskey();
            String tagPk = entity.getTagBusinesskey();
            String releSrcEntityInfo = String.format("%s.%s.%s", procInstId, srcEntityNumber, srcPk);
            if (!releEntityInfos.contains(releSrcEntityInfo)) {
                this.insertCompactRelaEntity(compactRelaManager, procInstId, srcEntityNumber, srcPk);
            }
            releEntityInfos.add(releSrcEntityInfo);
            String releTarEntityInfo = String.format("%s.%s.%s", procInstId, tagEntityNumber, tagPk);
            if (!releEntityInfos.contains(releTarEntityInfo)) {
                this.insertCompactRelaEntity(compactRelaManager, procInstId, tagEntityNumber, tagPk);
            }
            releEntityInfos.add(releTarEntityInfo);
        }
        if (WfUtils.isEmptyForMap(bizCompactEntityMap)) {
            return;
        }
        for (HistoricProcCompactEntity compactEntity : bizCompactEntityMap.values()) {
            this.insertCompactRelaEntity(compactRelaManager, compactEntity.getProcessInstanceId(), compactEntity.getEntityNumber(), compactEntity.getBusinessKey());
        }
    }

    private void insertCompactRelaEntity(HistoricCompactRelaEntityManager compactRelaManager, Long procInstId, String entityNumber, String businessKey) {
        HistoricCompactRelaEntity relaEntity = (HistoricCompactRelaEntity)compactRelaManager.create();
        relaEntity.setProcessInstanceId(procInstId);
        relaEntity.setEntityNumber(entityNumber);
        relaEntity.setBusinesskey(businessKey);
        compactRelaManager.insert(relaEntity);
    }

    private List<HistoricProcCompactEntity> initCompactEntitys(HistoricProcCompactEntityManager compactManager, List<HistoricProcessInstanceEntity> procInstList) {
        ArrayList<HistoricProcCompactEntity> compactEntitys = new ArrayList<HistoricProcCompactEntity>(procInstList.size());
        for (HistoricProcessInstanceEntity hiProc : procInstList) {
            HistoricProcCompactEntity compactEntity = (HistoricProcCompactEntity)compactManager.create();
            compactEntity.setProcessDefinitionId(hiProc.getProcessDefinitionId());
            compactEntity.setProcessInstanceId(hiProc.getProcessInstanceId());
            compactEntity.setBusinessKey(hiProc.getBusinessKey());
            compactEntity.setEntityNumber(hiProc.getEntitynumber());
            compactEntity.setBillNo(hiProc.getBillNo());
            compactEntity.setProcessType(hiProc.getProcessType());
            compactEntity.setBizTraceNo(hiProc.getBizTraceNo());
            compactEntity.setCreateDate(WfUtils.now());
            compactEntitys.add(compactEntity);
        }
        return compactEntitys;
    }

    private void completeCompactPropertys(CommandContext commandContext, List<HistoricProcCompactEntity> compactEntitys, List<Long> processInstanceIds) {
        if (WfUtils.isEmptyForCollection(compactEntitys) || WfUtils.isEmptyForCollection(processInstanceIds)) {
            return;
        }
        Set zipEntityPropertys = EntityMetadataCache.getDataEntityType((String)"wf_historicproccompact").getFields().keySet();
        CollectionBinder binder = new CollectionBinder();
        String entityNumber = this.compactParam.getEntityNumber();
        String zipPropertyName = this.compactParam.getCompactPropertyName();
        Set entityPropertys = EntityMetadataCache.getDataEntityType((String)entityNumber).getFields().keySet();
        AbstractEntityManager manager = commandContext.getEntityManagerByEntityNumber(entityNumber);
        if (manager == null || !zipEntityPropertys.contains(zipPropertyName.toLowerCase()) || !entityPropertys.contains(this.getPropertyNameOfProcInstId().toLowerCase())) {
            return;
        }
        List<Entity> entityList = manager.findByQueryFilters(new QFilter[]{new QFilter(this.getPropertyNameOfProcInstId(), "in", processInstanceIds)}, EntityCompactConfigFactory.getCollectPropertys(entityNumber), "id asc");
        if (WfUtils.isEmptyForCollection(entityList)) {
            return;
        }
        Map<Long, List<DynamicObject>> compactMap = this.groupByProcInstId(entityList);
        for (HistoricProcCompactEntity compactEntity : compactEntitys) {
            DynamicObject compactEntityDyn = compactEntity.getDynamicObject();
            CollectionSerialize collectionSerialize = new CollectionSerialize();
            List<DynamicObject> dyns = compactMap.get(compactEntity.getProcessInstanceId());
            if (dyns == null) continue;
            collectionSerialize.addDynamicObjects(dyns);
            String jsonStr = binder.getDcJsonSerializer().serializeToString((Object)collectionSerialize, null);
            compactEntityDyn.set(zipPropertyName, (Object)jsonStr);
        }
        manager.deleteByFilters(new QFilter[]{new QFilter(this.getPropertyNameOfProcInstId(), "in", processInstanceIds)});
    }

    private Map<Long, List<DynamicObject>> groupByProcInstId(List<Entity> entityList) {
        HashMap<Long, List<DynamicObject>> compactMap = new HashMap<Long, List<DynamicObject>>(this.procInstIds.size());
        for (Entity entity : entityList) {
            DynamicObject compactDyn = entity.getDynamicObject();
            Long procInstId = compactDyn.getLong(this.getPropertyNameOfProcInstId());
            compactMap.putIfAbsent(procInstId, new ArrayList(10));
            List compactDynList = (List)compactMap.get(procInstId);
            compactDynList.add(compactDyn);
        }
        return compactMap;
    }

    private String getPropertyNameOfProcInstId() {
        return this.compactParam.getPropertyNameOfProcInstId();
    }
}

