/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.handler.AbstractDeleteDatasByTimeHandler;
import kd.bos.workflow.engine.impl.handler.DeleteAddressingMsgByEvtLog;
import kd.bos.workflow.engine.impl.handler.DeleteAddressingMsgByJobRecord;
import kd.bos.workflow.engine.impl.handler.DeleteClosedJobHandler;
import kd.bos.workflow.engine.impl.handler.DeleteFailedJobHandler;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class DeleteFinishedProcessDatasCmd
implements Command<Void> {
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public Void execute(CommandContext commandContext) {
        if (!this.validate()) {
            return null;
        }
        ArrayList<AbstractDeleteDatasByTimeHandler> handlers = new ArrayList<AbstractDeleteDatasByTimeHandler>(4);
        handlers.add(new DeleteAddressingMsgByJobRecord());
        handlers.add(new DeleteAddressingMsgByEvtLog());
        handlers.add(new DeleteClosedJobHandler());
        handlers.add(new DeleteFailedJobHandler());
        if (WfConfigurationUtil.useCleanFrame()) {
            CleanDataCalculator.create().executeTimingCleaners("wfs_compact");
        }
        for (AbstractDeleteDatasByTimeHandler handler : handlers) {
            try {
                this.log.debug(String.format("key[%s]\uff0c\u6e05\u9664\u6570\u636ehandler\u5f00\u59cb\u6267\u884c\uff01", handler.getKey()));
                handler.execute(commandContext);
            }
            catch (Exception e) {
                this.log.error(String.format("\u5220\u9664\u6570\u636e\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
        }
        try {
            this.log.debug("deleteR3Tables\uff0c\u5f00\u59cb\u6267\u884c\uff01");
            this.deleteR3Tables();
        }
        catch (Exception e) {
            this.log.error(String.format("\u5220\u9664r3\u8868\u6570\u636e\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
        }
        return null;
    }

    private boolean validate() {
        StringBuilder sql = new StringBuilder();
        sql.append("select top 1 ");
        sql.append("fid ");
        sql.append("from t_msg_archive where fstate in ('archivefail','archiveing','archivewill')");
        try (DataSet ds = DB.queryDataSet((String)"DeleteFinishedProcessDatasCmd.queryArchive", (DBRoute)DBRoute.workflow, (String)sql.toString());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                this.log.debug("\u6d41\u7a0b\u6e05\u9664\u6570\u636e\u8c03\u5ea6\u4e0e\u5f52\u6863\u8c03\u5ea6\u51b2\u7a81\uff0c\u672c\u6b21\u4e0d\u6267\u884c\uff01");
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void deleteR3Tables() {
        String tables = (String)WfConfigurationUtil.getConfigCenterVal("workflow.schedule.deleteR3TableDatas");
        if ("false".equals(tables)) {
            this.log.debug("Do not enable the function of regularly deleting R3 table.");
            return;
        }
        String table = "t_wf_evtlog";
        if (WfUtils.isEmpty(tables)) {
            this.deleteR3Table(table);
            return;
        }
        String[] ts = tables.split(",");
        for (int i = 0; i < ts.length; ++i) {
            table = ts[i];
            this.deleteR3Table(table.trim());
        }
    }

    private void deleteR3Table(String table) {
        String r3Table = String.format("%s_r3", table);
        boolean existTable = DB.exitsTable((DBRoute)DBRoute.workflow, (String)r3Table);
        if (!existTable) {
            this.log.debug(String.format("table %s not exists!", r3Table));
            return;
        }
        this.log.debug(String.format("delete tabel %s datas", r3Table));
        int count = 0;
        int limit = this.getEveryTimeDeleteCount();
        String countSql = String.format("SELECT COUNT(1) CT FROM %s;", r3Table);
        try (DataSet ds = DB.queryDataSet((String)"wf.schedule.countR3TableDatas", (DBRoute)DBRoute.workflow, (String)countSql, null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getInteger("CT");
            }
        }
        this.log.debug(String.format("There is %s data in table %s.", count, r3Table));
        int size = Math.min(count, limit);
        if (size < 1) {
            return;
        }
        ArrayList<Object[]> idList = new ArrayList<Object[]>(size);
        String sql = String.format("SELECT TOP %s FID FROM %s;", size, r3Table);
        try (DataSet ds = DB.queryDataSet((String)"wf.schedule.queryDeleteR3TableDatas", (DBRoute)DBRoute.workflow, (String)sql, null);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                idList.add(new Long[]{((Row)iter.next()).getLong("FID")});
            }
        }
        if (idList.isEmpty()) {
            this.log.debug("There is no data to delete.");
            return;
        }
        String deleteSql = String.format("DELETE FROM %s WHERE FID = ?;", r3Table);
        WfUtils.executeBatch(deleteSql, idList, 1000);
    }

    private int getEveryTimeDeleteCount() {
        int deleteCount = 50000;
        String count = (String)WfConfigurationUtil.getConfigCenterVal("workflow.schedule.deleteR3TableDatasCount");
        if (count != null && count.matches("^\\d{1,8}$")) {
            deleteCount = Integer.parseInt(count);
        }
        return deleteCount;
    }
}

