/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;

public class FindConditionParseLogByBill
implements Command<List<ConditionParseLogEntity>> {
    private final String entityNumber;
    private final String billNoOrBusinessKey;

    public FindConditionParseLogByBill(String entityNumber, String billNoOrBusinessKey) {
        this.entityNumber = entityNumber;
        this.billNoOrBusinessKey = billNoOrBusinessKey;
    }

    @Override
    public List<ConditionParseLogEntity> execute(CommandContext commandContext) {
        QFilter eqEntityNumber = new QFilter("entitynumber", "=", (Object)this.entityNumber);
        QFilter eqBillNo = new QFilter("billno", "=", (Object)this.billNoOrBusinessKey);
        QFilter eqBusinessKey = new QFilter("businesskey", "=", (Object)this.billNoOrBusinessKey);
        QFilter eqBusinessKeyOrEqBillNo = eqBillNo.or(eqBusinessKey);
        List selectedTypeList = Arrays.stream(ConditionType.values()).filter(ConditionType::getSelected).map(Enum::name).collect(Collectors.toList());
        QFilter inSelectedTypeList = new QFilter("opname", "in", selectedTypeList);
        QFilter notEq = new QFilter("expression", "!=", (Object)"${ auditNumber IN \"Consent\" }");
        QFilter[] qFilters = eqEntityNumber.and(eqBusinessKeyOrEqBillNo).and(inSelectedTypeList).and(notEq).toArray();
        return commandContext.getConditionParseLogManager().findByQueryFilters(qFilters);
    }
}

