/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetActInstInfoCmd
implements Command<Map<String, List<Map<String, Object>>>> {
    private String businessKey;
    private List<String> actIds;
    private boolean isOnlyCompleted;
    private static final String COMMENT_LIST = "commentList";

    public GetActInstInfoCmd(String businessKey, List<String> actIds, boolean isOnlyCompleted) {
        this.businessKey = businessKey;
        this.actIds = actIds;
        this.isOnlyCompleted = isOnlyCompleted;
    }

    @Override
    public Map<String, List<Map<String, Object>>> execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.businessKey)) {
            throw new WFIllegalArgumentException("businessKey is null");
        }
        if (WfUtils.isEmptyForCollection(this.actIds)) {
            throw new WFIllegalArgumentException("actIds is null");
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(this.actIds.size());
        for (String actId : this.actIds) {
            result.put(actId, new ArrayList(10));
        }
        HistoricActivityInstanceEntityManager hiActEntityManager = commandContext.getHistoricActivityInstanceEntityManager();
        EntityQueryBuilder hiActEntityQuery = commandContext.getHistoricActivityInstanceEntityManager().createQueryBuilder();
        hiActEntityQuery.addFilter("businessKey", this.businessKey);
        hiActEntityQuery.addFilter("activityId", "in", this.actIds);
        if (this.isOnlyCompleted) {
            hiActEntityQuery.addFilter("endTime", "is not null", null);
        }
        hiActEntityQuery.orderBy(String.format("%s desc", "step"));
        List hiActInsts = hiActEntityManager.findByQueryBuilder(hiActEntityQuery);
        ArrayList<Long> taskIds = new ArrayList<Long>(hiActInsts.size());
        for (HistoricActivityInstanceEntity actInst : hiActInsts) {
            Long taskId = actInst.getTaskId();
            if (WfUtils.isNotEmpty(taskId)) {
                taskIds.add(actInst.getTaskId());
            }
            HashMap<String, Object> actMap = new HashMap<String, Object>(4);
            actMap.put("executionType", actInst.getExecutionType());
            actMap.put("taskId", taskId);
            actMap.put("step", actInst.getStep());
            actMap.put("endTime", actInst.getEndTime());
            actMap.put(COMMENT_LIST, new ArrayList(10));
            ((List)result.get(actInst.getActivityId())).add(actMap);
        }
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        EntityQueryBuilder commentEntityQuery = commentManager.createQueryBuilder();
        commentEntityQuery.addFilter("businessKey", this.businessKey);
        commentEntityQuery.addFilter("taskId", "in", taskIds);
        QFilter[] filters = commentEntityQuery.getFilters();
        List<CommentEntity> comments = commentManager.findApprovalRecordByAuth(filters, "");
        for (List list : result.values()) {
            for (Map actMap : list) {
                List comentList = (List)actMap.get(COMMENT_LIST);
                for (CommentEntity comment : comments) {
                    if (!actMap.get("taskId").equals(comment.getTaskId())) continue;
                    HashMap<String, String> commentPara = new HashMap<String, String>(16);
                    commentPara.put("type", comment.getType());
                    commentPara.put("decisionType", comment.getDecisionType());
                    commentPara.put("resultNumber", comment.getResultNumber());
                    comentList.add(commentPara);
                }
            }
        }
        return result;
    }
}

