/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.flowchart.ApprovalRecordsProcessHelper;
import kd.bos.workflow.engine.impl.flowchart.ApprovalRecordsStatus;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;

public class GetApprovalHistoryRecordsCmd
implements Command<List<ApprovalHistoryRecord>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long procInstId;
    protected String activityId;
    protected boolean historic;

    public GetApprovalHistoryRecordsCmd(Long procInstId, String activityId, boolean historic) {
        this.procInstId = procInstId;
        this.activityId = activityId;
        this.historic = historic;
    }

    @Override
    public List<ApprovalHistoryRecord> execute(CommandContext commandContext) {
        List<HistoricActivityInstanceEntity> actInstEntities = commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(this.procInstId, this.activityId);
        if (actInstEntities.isEmpty()) {
            return new ArrayList<ApprovalHistoryRecord>();
        }
        boolean isCurrent = false;
        for (HistoricActivityInstanceEntity entity : actInstEntities) {
            if (entity.getEndTime() != null || !WfUtils.isEmpty(entity.getAssigneeId())) continue;
            isCurrent = true;
            break;
        }
        ApprovalRecordsProcessHelper helper = null;
        helper = !this.historic ? (isCurrent ? new ApprovalRecordsProcessHelper(ApprovalRecordsStatus.CURRENT, this.procInstId, this.activityId, actInstEntities) : new ApprovalRecordsProcessHelper(ApprovalRecordsStatus.LATEST, this.procInstId, this.activityId, actInstEntities)) : (isCurrent ? new ApprovalRecordsProcessHelper(ApprovalRecordsStatus.CURRENTHISTORY, this.procInstId, this.activityId, actInstEntities) : new ApprovalRecordsProcessHelper(ApprovalRecordsStatus.HISTORY, this.procInstId, this.activityId, actInstEntities));
        return helper.getApprovalRecords();
    }
}

