/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.AuditPointHistoryRecord;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;
import kd.bos.workflow.engine.task.auditpoint.AuditPointType;

public class GetAuditPointHistoryRecordsCmd
implements Command<List<AuditPointHistoryRecord>>,
Serializable {
    private static final long serialVersionUID = -1824383580813872047L;
    private static final String TASKID = "ftaskid";
    protected Long procInstId;
    protected String activityId;
    private boolean isYzjAudit = false;
    private static final String FDISPLAYNAME = "fdisplayname";
    private static final String FFAILEDREASON = "ffailedreason";
    private static final String FASSIGNEENAME = "fassigneename";
    private static final String FAILREASON = "%s --- %s";
    private static final String FAILREALREASON = "%s\n\r\n\r%s";

    public GetAuditPointHistoryRecordsCmd(Long procInstId, String activityId) {
        this.activityId = activityId;
        this.procInstId = procInstId;
    }

    @Override
    public List<AuditPointHistoryRecord> execute(CommandContext commandContext) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "poi";
        String multiLangTableAlias = "poil";
        String entityNumber = "wf_auditpointinstance";
        String displayNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FDISPLAYNAME, FDISPLAYNAME, "displayname");
        String failedReasonSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FFAILEDREASON, FFAILEDREASON, "failedreason");
        String assigneeNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FASSIGNEENAME, FASSIGNEENAME, "assigneename");
        StringBuilder sql = new StringBuilder();
        sql.append("select poi.fauditpointseq,poi.ftaskid,poi.ftype,poi.fcheckresult,poi.fassigneeid,");
        sql.append(displayNameSQL).append(',').append(failedReasonSQL).append(',').append(assigneeNameSQL);
        sql.append(" from t_wf_hiauditpointinst poi ");
        sql.append("left join t_wf_hiauditpointinst_l poil on poi.fid = poil.fid ");
        sql.append("left join t_wf_hitaskinst hit on poi.ftaskid = hit.fid ");
        sql.append("where poi.fprocessinstanceid = ? and poi.factid = ? and hit.fhandlestate!= ? and poil.flocaleid = ? and poi.fisdisplay = '1' ");
        List<HistoricActivityInstanceEntity> actInstEntities = commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(this.procInstId, this.activityId);
        if (actInstEntities != null && actInstEntities.size() > 1) {
            sql.append("order by poi.fcreatedate desc,poi.ftaskid desc,poi.fauditpointseq asc");
        } else {
            sql.append("order by poi.fauditpointseq asc");
        }
        Object[] params = new Object[]{this.procInstId, this.activityId, "willApproval", lang};
        ArrayList<AuditPointHistoryRecord> records = new ArrayList<AuditPointHistoryRecord>();
        if (actInstEntities == null || actInstEntities.isEmpty()) {
            return new ArrayList<AuditPointHistoryRecord>();
        }
        if ("YunzhijiaTask".equalsIgnoreCase(actInstEntities.get(0).getActivityType())) {
            this.isYzjAudit = true;
        }
        try (DataSet ds = DB.queryDataSet((String)"AuditPointHistoryRecords.activity_approval_records", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params);){
            Iterator rows = ds.iterator();
            AuditPointHistoryRecord record = null;
            Long taskId = null;
            HashMap<Integer, AuditPointHistoryRecord> nextManualChecks = new HashMap<Integer, AuditPointHistoryRecord>();
            HashMap<Integer, AuditPointHistoryRecord> nextNewManualChecks = new HashMap<Integer, AuditPointHistoryRecord>();
            Boolean isFirstGroup = Boolean.TRUE;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                if (row == null) continue;
                int auditPointSeq = row.getInteger("fauditpointseq");
                String type = row.getString("ftype");
                String displayName = row.getString(FDISPLAYNAME);
                String checkResult = row.getString("fcheckresult");
                String failedReason = row.getString(FFAILEDREASON);
                String assigneeName = row.getString(FASSIGNEENAME);
                Long assigneeId = row.getLong("fassigneeid");
                if (WfUtils.isEmpty(taskId)) {
                    taskId = row.getLong(TASKID);
                }
                if (!this.isYzjAudit) {
                    if (taskId != null && !taskId.equals(row.getLong(TASKID))) {
                        break;
                    }
                    record = new AuditPointHistoryRecord();
                    record.setType(type);
                    record.setAuditPointSeq(auditPointSeq);
                    record.setDisplayName(displayName);
                    record.setCheckResult(checkResult);
                    record.setFailedReason(failedReason);
                    record.setAssigneeId(assigneeId);
                    records.add(record);
                    continue;
                }
                if (!this.isYzjAudit) continue;
                if (taskId != null && taskId.equals(row.getLong(TASKID))) {
                    record = new AuditPointHistoryRecord();
                    record.setType(type);
                    record.setAuditPointSeq(auditPointSeq);
                    record.setDisplayName(displayName);
                    record.setCheckResult(checkResult);
                    record.setFailedReason(failedReason);
                    record.setAssigneeId(assigneeId);
                    if (AuditPointType.MANUALCHECKS.getNumber().equals(type)) {
                        if (!AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                            record.setDisplayName(String.format("%s %s", displayName, assigneeName));
                        } else if (WfUtils.isNotEmpty(failedReason)) {
                            record.setFailedReason(String.format(FAILREASON, failedReason, assigneeName));
                        }
                    }
                    nextManualChecks.put(record.getAuditPointSeq(), record);
                    records.add(record);
                    continue;
                }
                if (!AuditPointType.MANUALCHECKS.getNumber().equals(type) || (record = (AuditPointHistoryRecord)nextManualChecks.get(auditPointSeq)) == null) continue;
                String preFailedReason = record.getFailedReason();
                String preDisplayName = record.getDisplayName();
                if (record.getCheckResult().equals(checkResult)) {
                    if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                        if (WfUtils.isEmpty(failedReason) || WfUtils.isEmpty(preFailedReason)) continue;
                        String nextFailedReason = String.format(FAILREASON, failedReason, assigneeName);
                        record.setFailedReason(String.format(FAILREALREASON, preFailedReason, nextFailedReason));
                        continue;
                    }
                    if (WfUtils.isEmpty(preDisplayName) || preDisplayName.contains(assigneeName)) continue;
                    record.setDisplayName(String.format("%s,%s", preDisplayName, assigneeName));
                    continue;
                }
                if (isFirstGroup.booleanValue()) {
                    if (preFailedReason.contains(assigneeName) || preDisplayName.contains(assigneeName)) continue;
                    AuditPointHistoryRecord newRecord = new AuditPointHistoryRecord();
                    newRecord.setAuditPointSeq(auditPointSeq);
                    newRecord.setDisplayName(displayName);
                    newRecord.setCheckResult(checkResult);
                    newRecord.setFailedReason(failedReason);
                    if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                        newRecord.setFailedReason(String.format(FAILREASON, failedReason, assigneeName));
                    } else {
                        newRecord.setDisplayName(String.format("%s %s", displayName, assigneeName));
                    }
                    nextNewManualChecks.put(newRecord.getAuditPointSeq(), newRecord);
                    records.add(newRecord);
                    isFirstGroup = Boolean.FALSE;
                    continue;
                }
                if (taskId == null || taskId.equals(row.getLong(TASKID)) || (record = (AuditPointHistoryRecord)nextNewManualChecks.get(auditPointSeq)) == null) continue;
                String newPreFailedReason = record.getFailedReason();
                String newDisplayName = record.getDisplayName();
                if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                    boolean isContainAssignee = false;
                    for (AuditPointHistoryRecord nextRecord : records) {
                        if (!type.equals(nextRecord.getType()) || !assigneeId.equals(nextRecord.getAssigneeId())) continue;
                        isContainAssignee = true;
                    }
                    if (WfUtils.isEmpty(failedReason) || WfUtils.isEmpty(newPreFailedReason) || newPreFailedReason.contains(assigneeName) || isContainAssignee) continue;
                    String nextFailedReason = String.format(FAILREASON, failedReason, assigneeName);
                    record.setFailedReason(String.format(FAILREALREASON, newPreFailedReason, nextFailedReason));
                    continue;
                }
                if (WfUtils.isEmpty(newDisplayName) || newDisplayName.contains(assigneeName)) continue;
                record.setDisplayName(String.format("%s,%s", newDisplayName, assigneeName));
            }
        }
        Collections.sort(records, new Comparator<AuditPointHistoryRecord>(){

            @Override
            public int compare(AuditPointHistoryRecord record1, AuditPointHistoryRecord record2) {
                return record1.getAuditPointSeq().compareTo(record2.getAuditPointSeq());
            }
        });
        return records;
    }
}

