/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricJobRecordEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;

public class MoveFinishedProcessJobsToHistoryCmd
implements Command<Void> {
    private static Log log = LogFactory.getLog(MoveFinishedProcessJobsToHistoryCmd.class);
    private List<String> businessKeys;
    private List<String> entityNumbers;
    private Long procInstId;

    @Deprecated
    public MoveFinishedProcessJobsToHistoryCmd(List<String> businessKeys) {
        this.businessKeys = businessKeys;
    }

    @Deprecated
    public MoveFinishedProcessJobsToHistoryCmd(List<String> entityNumbers, List<String> businessKeys) {
        this.entityNumbers = entityNumbers;
        this.businessKeys = businessKeys;
    }

    public MoveFinishedProcessJobsToHistoryCmd(List<String> entityNumbers, List<String> businessKeys, Long procInstId) {
        this.entityNumbers = entityNumbers;
        this.businessKeys = businessKeys;
        this.procInstId = procInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.businessKeys) || WfUtils.isEmptyForCollection(this.entityNumbers) || WfUtils.isEmpty(this.procInstId)) {
            return null;
        }
        JobEntityManager jobEntityManager = commandContext.getJobEntityManager();
        List<Long> procInstIds = this.getSubProcInstIds(commandContext, this.businessKeys, this.procInstId);
        ArrayList<Object> params = new ArrayList<Object>(procInstIds.size());
        params.addAll(procInstIds);
        String batchSql = "DELETE FROM T_WF_JOBRECORD WHERE FHANDLERTYPE = 'async-timing' AND FPROCESSINSTANCEID IN (?);";
        try (TXHandle txHandle = TX.requiresNew();){
            WfDBUtils.executeBatchDeleteByIn(batchSql, params, 500, true);
        }
        List<JobEntity> jobEntityList = this.findNeedMoveJobs(jobEntityManager, procInstIds);
        HistoricJobRecordEntityManager manager = commandContext.getHistoricJobRecordEntityManager();
        if (jobEntityList != null) {
            for (JobEntity jobEntity : jobEntityList) {
                manager.copyAndInsert(jobEntity);
                jobEntityManager.delete(jobEntity);
            }
        }
        return null;
    }

    private List<JobEntity> findNeedMoveJobs(JobEntityManager jobEntityManager, List<Long> procInstIds) {
        if (WfUtils.isEmptyForCollection(procInstIds)) {
            return new ArrayList<JobEntity>(1);
        }
        List<JobEntity> allJobEntityList = jobEntityManager.findFinshedJobsByEntityNumbersAndBusinessKeys(this.entityNumbers, this.businessKeys);
        if (WfUtils.isEmptyForCollection(allJobEntityList)) {
            return allJobEntityList;
        }
        ArrayList<JobEntity> needMoveJobs = new ArrayList<JobEntity>(allJobEntityList.size());
        for (Long processInstId : procInstIds) {
            ArrayList<JobEntity> oneProcJobs = new ArrayList<JobEntity>(allJobEntityList.size());
            for (JobEntity jobEntity : allJobEntityList) {
                if (processInstId == null || !processInstId.equals(jobEntity.getProcessInstanceId())) continue;
                oneProcJobs.add(jobEntity);
            }
            if (WfUtils.isNotEmptyForCollection(oneProcJobs)) {
                JobEntity firstJob = (JobEntity)oneProcJobs.get(0);
                oneProcJobs.addAll(this.getAddressAndStartingJob(firstJob, allJobEntityList));
            }
            needMoveJobs.addAll(oneProcJobs);
        }
        return needMoveJobs;
    }

    private List<JobEntity> getAddressAndStartingJob(JobEntity firstJob, List<JobEntity> allJobEntityList) {
        Long srcJobId = firstJob.getSrcJobId();
        ArrayList<JobEntity> addressAndStartingJobs = new ArrayList<JobEntity>(2);
        while (WfUtils.isNotEmpty(srcJobId)) {
            boolean findSrcJobSuccess = false;
            for (JobEntity jobEntity : allJobEntityList) {
                if (!srcJobId.equals(jobEntity.getId())) continue;
                addressAndStartingJobs.add(jobEntity);
                srcJobId = jobEntity.getSrcJobId();
                findSrcJobSuccess = true;
                break;
            }
            if (findSrcJobSuccess) continue;
            break;
        }
        return addressAndStartingJobs;
    }

    private List<Long> getSubProcInstIds(CommandContext commandContext, List<String> businessKeys, Long procInstId) {
        ArrayList<Long> allProcInstIds = new ArrayList<Long>(10);
        List allProcInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("businessKey", "in", businessKeys), new QFilter("rootProcessInstanceId", "=", (Object)procInstId)}, "id", "id asc");
        if (WfUtils.isEmptyForCollection(allProcInsts)) {
            return allProcInstIds;
        }
        for (HistoricProcessInstanceEntity procInst : allProcInsts) {
            allProcInstIds.add(procInst.getId());
        }
        return allProcInstIds;
    }
}

